/**
 * FileName: AliyunClient
 * Author:   wenjunlong
 * Date:     2018/6/6 13:36
 * Description: 阿里云第三方接口调用
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package com.yizhi.aliyun.application.feign;

import com.yizhi.aliyun.application.vo.UploadParamVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.client.loadbalancer.reactive.Response;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 〈一句话功能简述〉<br>
 * 〈阿里云第三方接口调用〉
 *
 * @author wenjunlong
 * @create 2018/6/6
 * @since 1.0.0
 */
@FeignClient(name = "aliyun", contextId = "AliyunClient")
public interface AliyunClient {

    @ApiOperation(value = "视频上传", notes = "视频上传", response = Response.class)
    @RequestMapping(value = "/video/urlUpload", method = RequestMethod.POST)
    String upload(
            @RequestBody UploadParamVo uploadParamVo
    );

    @ApiOperation(value = "获取视频播放地址", notes = "获取视频播放地址", response = Response.class)
    @RequestMapping(value = "/video/movieurls", method = RequestMethod.GET)
    String movieurls(
            @ApiParam(name = "videoId", value = "视频ID", required = true) @RequestParam("videoId") String videoId
    );


    @GetMapping("/ali/addMedia/dealFinishedTranscoding")
    boolean dealFinishedTranscoding();

    /**
     * 获取文件的下载路径
     *
     * @param sourceUrl oss的预览地址
     * @return 返回为空表示后获下载地址失败
     */
    @GetMapping("/video/change/download")
    String downloadObjectHeader(@RequestParam("sourceUrl") String sourceUrl);

}
