/**
 * FileName: UploadParamVo
 * Author:   wenjunlong
 * Date:     2018/5/24 18:55
 * Description: 文件上传vo
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package com.yizhi.aliyun.application.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 〈一句话功能简述〉<br> 
 * 〈文件上传vo〉
 *
 * @author wenjunlong
 * @create 2018/5/24
 * @since 1.0.0
 */
@Data
public class UploadParamVo {

    @ApiModelProperty(name = "fileType", value = "上传文件类型 1为本地视频，2位网络url视频", required = true)
    String fileType;
    @ApiModelProperty(name = "title", value = "视频标题", required = true)
    String title;
    @ApiModelProperty(name = "fileName", value = "1.本地文件上传时，文件名称为上传文件绝对路径，如:/User/sample/文件名称.mp4 (必选) " +
            "2.网络流上传时，文件名称为源文件名，如文件名称.mp4(必选)。任何上传方式文件名必须包含扩展名", required = true)
    String fileName;
    @ApiModelProperty(name = "url", value = "当文件类型为2的时候必填，网络文件url", required = false)
    String url;
    @ApiModelProperty(name = "description", value = "视频描述", required = false)
    String description;
    @ApiModelProperty(name = "cateId", value = "视频分类ID,数字Integer类型", required = false)
    Integer cateId;
    @ApiModelProperty(name = "tags", value = "视频标签,多个用逗号分隔", required = false)
    String tags;
    @ApiModelProperty(name = "coverURL", value = "封面图片(可选),网络url", required = false)
    String coverURL;
    @ApiModelProperty(name = "isShowWaterMark", value = "是否使用默认水印，布尔型0/1", required = false)
    Boolean isShowWaterMark;

}
