package com.yizhi.aliyun.application;

import org.springframework.amqp.core.Queue;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;

/**
 * 
 * @author scotthu
 *
 * @date 2018年2月28日
 */

@SpringBootApplication(exclude = {RabbitAutoConfiguration.class})
@EnableDiscoveryClient
@EnableFeignClients("com.yizhi")
@ComponentScan("com.yizhi")
public class AliyunApplication {

	public static void main(java.lang.String[] args) {
		SpringApplication.run(AliyunApplication.class, args);
	}

	@Bean
	public Queue createassignmentMediaTranscodingQueue() {
		return new Queue("assignmentMediaTranscoding", true, false, false);
	}

}
