package com.yizhi.aliyun.application.controller;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.aliyun.application.mapper.AddMediaResponseRecordMapper;
import com.yizhi.aliyun.application.service.DealMediaTranscode;
import com.yizhi.aliyun.application.vo.AddMediaResponseRecordVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @ClassName AddMediaController
 * @Description TODO
 * @Author shengchenglong
 * @DATE 2019-10-18 15:25
 * @Version 1.0
 */
@RestController
@RequestMapping("/ali/addMedia")
public class AddMediaController {

    @Autowired
    private DealMediaTranscode dealMediaTranscode;
    @Autowired
    private AddMediaResponseRecordMapper addMediaResponseRecordMapper;

    @GetMapping("dealFinishedTranscoding")
    public boolean dealFinishedTranscoding() {
        AddMediaResponseRecordVO responseRecord = new AddMediaResponseRecordVO();
        responseRecord.setHasProcessed(0);
        List<AddMediaResponseRecordVO> records = addMediaResponseRecordMapper.selectList(new EntityWrapper<>(responseRecord));
        if (CollectionUtils.isNotEmpty(records)) {
            try {
                records.forEach(r -> dealMediaTranscode.dealFinishedTranscoding(r));
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

}
