package com.yizhi.aliyun.application.controller;

import cn.hutool.core.util.StrUtil;
import com.yizhi.aliyun.application.util.PropertiesUtil;
import com.yizhi.core.application.file.util.MinioTools;
import com.yizhi.util.application.domain.Response;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

@RestController
@Slf4j
@RequestMapping("/api")
public class FileUploadController {

    @Autowired
    private MinioTools minioTools;

    @Autowired
    PropertiesUtil propertiesUtil;

    @Value("${pc.host.url}")
    String pcHostUrl;
 
    @PostMapping("/upload")
    public Response<String> uploadFile() {
        try {
            HttpServletRequest httpRequest = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
            StandardServletMultipartResolver resolver = new StandardServletMultipartResolver();
            MultipartHttpServletRequest multipartRequest = resolver.resolveMultipart(httpRequest);
            MultipartFile file = multipartRequest.getFile("file");
            String bucketName =propertiesUtil.getPublicParam().get("ossdir");;
            String fileName = file.getOriginalFilename();
            fileName= StringUtils.deleteWhitespace(fileName);
            if (StrUtil.isNotBlank(fileName)) {
                fileName = fileName.replaceFirst("(\\.\\w+)$", "_" + System.currentTimeMillis() + "$1");
            } else {
                fileName = String.format("temp_%s.jpg", System.currentTimeMillis());
            }
            log.info("============={} -> 文件大小：{}===========",fileName, file.getSize());
            minioTools.uplodFile(bucketName,fileName,file.getInputStream());
            return Response.ok(pcHostUrl+"/api/v1/buckets/"+bucketName+"/objects/download/?preview=true&prefix="+fileName);
        } catch (IOException ex) {
            return Response.fail("Could not upload the file ");
        }
    }
}