package com.yizhi.aliyun.application.controller;


import com.aliyun.oss.ClientException;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.GeneratePresignedUrlRequest;
import com.yizhi.aliyun.application.util.PropertiesUtil;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.net.URL;

@RestController
@RequestMapping(value = "/image")
public class ImageController {

    @Autowired
    PropertiesUtil propertiesUtil;

    @ApiOperation(value = "图片自定义处理", notes = "图片自定义处理", response = Response.class)
    @RequestMapping(value = "/style", method = RequestMethod.GET)
    public Response<String> style(
            @ApiParam(name = "key", value = "图片在oss存储路径", required = true) @RequestParam(value = "key", required = true) String key,
            @ApiParam(name = "styleName", value = "自定义样式名", required = true) @RequestParam(value = "styleName", required = true) String styleName
            ) {
        String endpoint = propertiesUtil.getPublicParam().get("endpoint");
        String accessKeyId = propertiesUtil.getPublicParam().get("accessKeyId");
        String accessKeySecret = propertiesUtil.getPublicParam().get("accessKeySecret");
        OSSClient ossClient = new OSSClient(endpoint, accessKeyId, accessKeySecret);
        String bucketName = propertiesUtil.getPublicParam().get("bucket");

        try {

            // 图片处理样式
            String style = "style/"+styleName;
            // 过期时间10分钟
            java.util.Date expiration = new java.util.Date(new java.util.Date().getTime() + 1000 * 60 * 10 );
            GeneratePresignedUrlRequest req = new GeneratePresignedUrlRequest(bucketName, key, HttpMethod.GET);
            req.setExpiration(expiration);
            req.setProcess(style);
            URL signedUrl = ossClient.generatePresignedUrl(req);
            System.out.println(signedUrl);
            return Response.ok(signedUrl.toString());
        } catch (OSSException oe) {
            System.out.println("Caught an OSSException, which means your request made it to OSS, "
                    + "but was rejected with an error response for some reason.");
            System.out.println("Error Message: " + oe.getErrorCode());
            System.out.println("Error Code:       " + oe.getErrorCode());
            System.out.println("Request ID:      " + oe.getRequestId());
            System.out.println("Host ID:           " + oe.getHostId());
            return  Response.fail(oe.getMessage());
        } catch (ClientException ce) {
            System.out.println("Caught an ClientException, which means the client encountered "
                    + "a serious internal problem while trying to communicate with OSS, "
                    + "such as not being able to access the network.");
            System.out.println("Error Message: " + ce.getMessage());
            return  Response.fail(ce.getMessage());
        } catch (Throwable e) {
            e.printStackTrace();
            return  Response.fail(e.getMessage());
        } finally {
            ossClient.shutdown();
        }
    }
}
