package com.yizhi.aliyun.application.controller;

import com.alibaba.fastjson.JSON;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.GeneratePresignedUrlRequest;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.PolicyConditions;
import com.yizhi.aliyun.application.util.AESCoder;
import com.yizhi.aliyun.application.util.PropertiesUtil;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.net.URL;
import java.sql.Date;
import java.util.LinkedHashMap;
import java.util.Map;

@RestController
@RequestMapping(value = "/upload")
public class PolicyController {

    private static final Logger LOGGER = LoggerFactory.getLogger(PolicyController.class);

    @Value("${ACTIVE}")
    public String active;

    @Value("${pc.host.url}")
    String pcHostUrl;

    @Autowired
    PropertiesUtil propertiesUtil;

    @ApiOperation(value = "web端上传签名获得", notes = "web端上传签名获得", response = Response.class)
    @RequestMapping(value = "/policy", method = RequestMethod.GET)
    public Response<String> token(@RequestParam(name = "needTranscode", required = false) Boolean needTranscode, @RequestParam(name = "type", required = false, defaultValue = "0") Integer type) {

        /*RequestContext context = ContextHolder.get();
        if(context==null||context.getAccountId()==null||context.getAccountId()==0L){
            return Response.fail("未登录！禁止访问");
        }
        LOGGER.info("登录人：{},{}",context.getAccountId(),context.getAccountName());*/
        String endpoint = propertiesUtil.getPublicParam().get("endpoint");
        String accessId = propertiesUtil.getPublicParam().get("accessKeyId");
        String accessKey = propertiesUtil.getPublicParam().get("accessKeySecret");
        String dir = propertiesUtil.getPublicParam().get("ossdir");
        String bucket = null;

        if (needTranscode == null || !needTranscode) {
            bucket = propertiesUtil.getPublicParam().get("bucket");
        } else {
            bucket = propertiesUtil.getPublicParam().get("transcodeBucket");
            switch (type) {
                //作业本
                case 0:
                    dir = "exerciseBook";
                    break;
                //资料
                case 1:
                    dir = "document";
                    break;
                //案例
                case 2:
                    dir = "studentCase";
                    break;
                //论坛
                case 3:
                    dir = "forum";
                    break;
            }
        }

        String host = "https://" + bucket + "." + endpoint;
        //String host = pcHostUrl+"/api/v1/buckets/"+dir+"/objects/download/?preview=true&prefix=";

        OSSClient client = new OSSClient(endpoint, accessId, accessKey);
        try {

            long expireTime = 60 * 24;
            long expireEndTime = System.currentTimeMillis() + expireTime * 1000;
            Date expiration = new Date(expireEndTime);
            PolicyConditions policyConds = new PolicyConditions();
            policyConds.addConditionItem(PolicyConditions.COND_CONTENT_LENGTH_RANGE, 0, 10485760000L);
            policyConds.addConditionItem(MatchMode.StartWith, PolicyConditions.COND_KEY, dir);

            String postPolicy = client.generatePostPolicy(expiration, policyConds);
            byte[] binaryData = postPolicy.getBytes("utf-8");
            String encodedPolicy = BinaryUtil.toBase64String(binaryData);
            String postSignature = client.calculatePostSignature(postPolicy);


            Map<String, String> respMap = new LinkedHashMap<String, String>();
            respMap.put("accessid", accessId);
            respMap.put("policy", encodedPolicy);
            respMap.put("signature", postSignature);
            //respMap.put("expire", formatISO8601Date(expiration));
            respMap.put("dir", dir);
            respMap.put("host", host);
            respMap.put("expire", String.valueOf(expireEndTime / 1000));
            respMap.put("active", active);
            JSONObject ja1 = JSONObject.fromObject(respMap);
            System.out.println(ja1.toString());

            return Response.ok(ja1.toString());
        } catch (Exception e) {
            return Response.fail(e.getMessage());
        } finally {
            client.shutdown();
        }

    }

    @ApiOperation(value = "web端下载授权签名获得", notes = "web端下载授权签名获得", response = Response.class)
    @RequestMapping(value = "/download/url", method = RequestMethod.GET)
    public Response<String> download(
            @ApiParam(name = "key", value = "文件在oss存储路径", required = true) @RequestParam(value = "key", required = true) String key
    ) {
        /*RequestContext context = ContextHolder.get();
        if(context==null||context.getAccountId()==null||context.getAccountId()==0L){
            return Response.fail("未登录！禁止访问");
        }
        LOGGER.info("登录人：{},{}",context.getAccountId(),context.getAccountName());*/
        String endpoint = propertiesUtil.getPublicParam().get("endpoint");
        String accessId = propertiesUtil.getPublicParam().get("accessKeyId");
        String accessKey = propertiesUtil.getPublicParam().get("accessKeySecret");
        String bucket = propertiesUtil.getPublicParam().get("bucket");
        OSSClient Server = new OSSClient(endpoint, accessId, accessKey);

        try {

            long expireTime = 30;
            long expireEndTime = System.currentTimeMillis() + expireTime * 1000;
            Date expiration = new Date(expireEndTime);
            GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(bucket, key, HttpMethod.GET);
            //设置过期时间
            request.setExpiration(expiration);
            // 生成URL签名(HTTP GET请求)
            URL signedUrl = Server.generatePresignedUrl(request);

            return Response.ok(signedUrl.toString());
        } catch (Exception e) {
            return Response.fail(e.getMessage());
        } finally {
            Server.shutdown();
        }

    }

    @ApiOperation(value = "AES加密字符串获得", notes = "AES加密字符串获得", response = Response.class)
    @RequestMapping(value = "/getAesKey", method = RequestMethod.GET)
    public Response<String> getAesKey() {
        Map<String, String> map = propertiesUtil.getPublicParam();
        String content = JSON.toJSONString(map);
        String enString = "";
        try {
            enString = AESCoder.Encrypt(content, AESCoder.KEY);
        } catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
        }
        return Response.ok(enString);
    }


}
