package com.yizhi.aliyun.application.controller;

import com.alibaba.fastjson.JSONObject;
import com.yizhi.aliyun.application.service.UploadVideoApi;
import com.yizhi.aliyun.application.service.VideoInfoApi;
import com.yizhi.aliyun.application.domain.*;
import com.yizhi.aliyun.application.vo.UploadParamVo;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

@RestController
@RequestMapping(value = "/video")
public class VideoController {

    @Autowired
    private UploadVideoApi uploadVideoApi;

    @Autowired
    private VideoInfoApi videoInfoApi;


    @ApiOperation(value = "视频上传", notes = "视频上传", response = Response.class)
    @RequestMapping(value = "/upload", method = RequestMethod.POST)
    public Response<String> upload(
            @RequestBody UploadParamVo uploadParamVo
//            @ApiParam(name = "fileType", value = "上传文件类型 1为本地视频，2位网络url视频", required = true) @RequestParam(value = "fileType", required = true) String fileType,
//            @ApiParam(name = "title", value = "视频标题", required = true) @RequestParam(value = "title", required = true) String title,
//            @ApiParam(name = "fileName", value = "1.本地文件上传时，文件名称为上传文件绝对路径，如:/User/sample/文件名称.mp4 (必选) " +
//                    "2.网络流上传时，文件名称为源文件名，如文件名称.mp4(必选)。任何上传方式文件名必须包含扩展名", required = true) @RequestParam(value = "fileName", required = true) String fileName,
//            @ApiParam(name = "url", value = "当文件类型为2的时候必填，网络文件url", required = false) @RequestParam(value = "url", required = false) String url,
//            @ApiParam(name = "description", value = "视频描述", required = false) @RequestParam(value = "description", required = false) String description,
//            @ApiParam(name = "cateId", value = "视频分类ID,数字Integer类型", required = false) @RequestParam(value = "cateId", required = false) Integer cateId,
//            @ApiParam(name = "tags", value = "视频标签,多个用逗号分隔", required = false) @RequestParam(value = "tags", required = false) String tags,
//            @ApiParam(name = "coverURL", value = "封面图片(可选),网络url", required = false) @RequestParam(value = "coverURL", required = false) String coverURL,
//            @ApiParam(name = "isShowWaterMark", value = "是否使用默认水印，布尔型0/1", required = false) @RequestParam(value = "isShowWaterMark", required = false) Boolean isShowWaterMark
    ) {

        String result = "";
        if ("1".equals(uploadParamVo.getFileType())) {
            UploadVideoVo uploadVideoVo = new UploadVideoVo();
            uploadVideoVo.setTitle(uploadParamVo.getTitle());
            uploadVideoVo.setFileName(uploadParamVo.getFileName());
            if (uploadParamVo.getDescription()!= null) {
                uploadVideoVo.setDescription(uploadParamVo.getDescription());
            }
            if (uploadParamVo.getCateId() != null) {
                uploadVideoVo.setCateId(uploadParamVo.getCateId());
            }
            if (uploadParamVo.getTags() != null) {
                uploadVideoVo.setTags(uploadParamVo.getTags());
            }
            if (uploadParamVo.getCoverURL() != null) {
                uploadVideoVo.setCoverURL(uploadParamVo.getCoverURL());
            }
            if (uploadParamVo.getIsShowWaterMark() != null) {
                uploadVideoVo.setShowWaterMark(uploadParamVo.getIsShowWaterMark());
            }
            result = uploadVideoApi.UploadVideoLocal(uploadVideoVo);
        } else if ("2".equals(uploadParamVo.getFileType())) {
            UploadVideoURLStreamVo uploadVideoURLStreamVo = new UploadVideoURLStreamVo();
            uploadVideoURLStreamVo.setTitle(uploadParamVo.getTitle());
            uploadVideoURLStreamVo.setFileName(uploadParamVo.getFileName());
            if (uploadParamVo.getUrl() != null) {
                uploadVideoURLStreamVo.setURL(uploadParamVo.getUrl());
            } else {
                return Response.fail("fileType为2的情况下url不能为空！");
            }
            if (uploadParamVo.getDescription() != null) {
                uploadVideoURLStreamVo.setDescription(uploadParamVo.getDescription());
            }
            if (uploadParamVo.getCateId() != null) {
                uploadVideoURLStreamVo.setCateId(uploadParamVo.getCateId());
            }
            if (uploadParamVo.getTags() != null) {
                uploadVideoURLStreamVo.setTags(uploadParamVo.getTags());
            }
            if (uploadParamVo.getCoverURL() != null) {
                uploadVideoURLStreamVo.setCoverURL(uploadParamVo.getCoverURL());
            }
            if (uploadParamVo.getIsShowWaterMark() != null) {
                uploadVideoURLStreamVo.setShowWaterMark(uploadParamVo.getIsShowWaterMark());
            }
            result = uploadVideoApi.uploadURLStream(uploadVideoURLStreamVo);
        }
        return Response.ok(result);
    }

    @ApiOperation(value = "获取视频信息", notes = "获取视频信息", response = Response.class)
    @RequestMapping(value = "/info", method = RequestMethod.GET)
    public Response<String> info(
            @ApiParam(name = "videoId", value = "视频id", required = true) @RequestParam("videoId") String videoId
    ) {
        return Response.ok(videoInfoApi.getVideoInfo(videoId));
    }

    @ApiOperation(value = "删除视频", notes = "删除视频", response = Response.class)
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public Response<String> delete(
            @ApiParam(name = "videoIds", value = "视频ID列表，多个用逗号分隔，最多支持10个", required = true) @RequestParam("videoIds") String videoIds
    ) {
        return Response.ok(videoInfoApi.deleteVideo(videoIds));
    }


    @ApiOperation(value = "修改视频信息", notes = "修改视频信息", response = Response.class)
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public Response<String> update(
            @ApiParam(name = "videoId", value = "视频ID", required = true) @RequestParam("videoId") String videoId,
            @ApiParam(name = "title", value = "视频标题，长度不超过128个字节，UTF8编码", required = false) @RequestParam(value = "title", required = false) String title,
            @ApiParam(name = "description", value = "视频描述，长度不超过1024个字节，UTF8编码", required = false) @RequestParam(value = "description", required = false) String description,
            @ApiParam(name = "coverURL", value = "视频封面URL地址", required = false) @RequestParam(value = "coverURL", required = false) String coverURL,
            @ApiParam(name = "cateId", value = "视频分类ID", required = false) @RequestParam(value = "cateId", required = false) String cateId,
            @ApiParam(name = "tags", value = "标签", required = false) @RequestParam(value = "tags", required = false) String tags
    ) {
        UpdateVideoInfoRequest updateVideoInfoRequest = new UpdateVideoInfoRequest();
        updateVideoInfoRequest.setVideoId(videoId);
        if (title != null) {
            updateVideoInfoRequest.setTitle(title);
        }
        if (description != null) {
            updateVideoInfoRequest.setDescription(description);
        }
        if (coverURL != null) {
            updateVideoInfoRequest.setCoverURL(coverURL);
        }
        if (cateId != null) {
            updateVideoInfoRequest.setCateId(cateId);
        }
        if (tags != null) {
            updateVideoInfoRequest.setTags(tags);
        }
        return Response.ok(videoInfoApi.updateVideoInfo(updateVideoInfoRequest));
    }

    @ApiOperation(value = "获取视频列表", notes = "获取视频列表", response = Response.class)
    @GetMapping(value = "/list")
    public Response<String> list(
            @ApiParam(name = "status", value = "视频状态，默认获取所有视频，多个可以用逗号分隔，如：Uploading,Normal，" +
                    "取值包括：Uploading(上传中)，UploadSucc(上传完成)，Transcoding(转码中)，TranscodeFail(转码失败)，Checking(审核中), " +
                    "Blocked(屏蔽)，Normal(正常)", required = false) @RequestParam(value = "status", required = false) String status,
            @ApiParam(name = "startTime", value = "视CreationTime（创建时间）的开始时间，为开区间(大于开始时间)。" +
                    "日期格式按照ISO8601标准表示，并需要使用UTC时间。格式为：YYYY-MM-DDThh:mm:ssZ " +
                    "例如，2017-01-11T12:00:00Z（为北京时间2017年1月11日20点0分0秒）", required = false) @RequestParam(value = "startTime", required = false) String startTime,
            @ApiParam(name = "endTime", value = "CreationTime的结束时间，为闭区间(小于等于结束时间)。" +
                    "日期格式按照ISO8601标准表示,并需要使用UTC时间。格式为：YYYY-MM-DDThh:mm:ssZ " +
                    "例如，2017-01-11T12:00:00Z（为北京时间2017年1月11日20点0分0秒）", required = false) @RequestParam(value = "endTime", required = false) String endTime,
            @ApiParam(name = "cateId", value = "视频分类ID", required = false) @RequestParam(value = "cateId", required = false) String cateId,
            @ApiParam(name = "pageNo", value = "页号，默认1", required = false) @RequestParam(value = "pageNo", required = false) Long pageNo,
            @ApiParam(name = "pageSize", value = "默认10，最大不超过100", required = false) @RequestParam(value = "pageSize", required = false) Long pageSize,
            @ApiParam(name = "sortBy", value = "结果排序，范围：CreationTime:Desc、CreationTime:Asc，默认为CreationTime:Desc（即按创建时间倒序）", required = false) @RequestParam(value = "sortBy", required = false) String sortBy
    ) {
        GetVideoListRequest getVideoListRequest = new GetVideoListRequest();
        if (status != null) {
            getVideoListRequest.setStatus(status);
        }
        if (startTime != null) {
            getVideoListRequest.setStartTime(startTime);
        }
        if (endTime != null) {
            getVideoListRequest.setEndTime(endTime);
        }
        if (cateId != null) {
            getVideoListRequest.setCateId(cateId);
        }
        if (pageNo != null) {
            getVideoListRequest.setPageNo(pageNo);
        }
        if (pageSize != null) {
            getVideoListRequest.setPageSize(pageSize);
        }
        if (sortBy != null) {
            getVideoListRequest.setSortBy(sortBy);
        }
        return Response.ok(videoInfoApi.getVideoList(getVideoListRequest));
    }


    @ApiOperation(value = "获取视频播放地址", notes = "获取视频播放地址", response = Response.class)
    @RequestMapping(value = "/play", method = RequestMethod.GET)
    public Response<String> play(
            @ApiParam(name = "videoId", value = "视频ID", required = true) @RequestParam("videoId") String videoId,
            @ApiParam(name = "formats", value = "视频流格式，多个用逗号分隔，支持格式mp4,m3u8,mp3，默认获取所有格式的流", required = false) @RequestParam(value = "formats", required = false) String formats,
            @ApiParam(name = "authTimeout", value = "播放地址过期时间，默认为3600秒，" +
                    "支持设置最小值为3600秒（当指定时间小于3600秒时，设置为默认3600秒）。" +
                    "只有开启了URL鉴权才会生效", required = false) @RequestParam(value = "authTimeout", required = false) String authTimeout,
            @ApiParam(name = "streamType", value = "视频流类型，多个用逗号分隔，支持类型video,audio，默认获取所有类型的流", required = false) @RequestParam(value = "streamType", required = false) String streamType,
            @ApiParam(name = "definition", value = "视频流清晰度，多个用逗号分隔，取值FD(流畅)，LD(标清)，" +
                    "SD(高清)，HD(超清)，OD(原画)，2K(2K)，4K(4K)，默认获取所有清晰度的流", required = false) @RequestParam(value = "definition", required = false) String definition
    ) {
        GetPlayInfoRequest getPlayInfoRequest = new GetPlayInfoRequest();
        getPlayInfoRequest.setVideoId(videoId);
        if (formats != null) {
            getPlayInfoRequest.setFormats(formats);
        }
        if (authTimeout != null) {
            getPlayInfoRequest.setAuthTimeout(authTimeout);
        }
        if (streamType != null) {
            getPlayInfoRequest.setStreamType(streamType);
        }
        if (definition != null) {
            getPlayInfoRequest.setDefinition(definition);
        }
        String result = videoInfoApi.GetPlayInfo(getPlayInfoRequest);
        JSONObject jsStr = JSONObject.parseObject(result);
        return Response.ok(jsStr);
    }


    @ApiOperation(value = "取视频上传凭证和地址", notes = "取视频上传凭证和地址", response = Response.class)
    @RequestMapping(value = "/uploadAuth", method = RequestMethod.GET)
    public Response<String> uploadAuth(
            @ApiParam(name = "fileName", value = "视频源文件名称", required = true) @RequestParam("fileName") String fileName,
            @ApiParam(name = "title", value = "视频标题", required = true) @RequestParam(value = "title", required = true) String title,
            @ApiParam(name = "cateId", value = "分类ID", required = false) @RequestParam(value = "cateId", required = false) String cateId,
            @ApiParam(name = "tags", value = "视频标签，多个用逗号分隔", required = false) @RequestParam(value = "tags", required = false) String tags,
            @ApiParam(name = "description", value = "视频描述", required = false) @RequestParam(value = "description", required = false) String description
    ) {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("fileName",fileName);
        map.put("title",title);
        if (cateId!=null){map.put("cateId",cateId);}
        if (cateId!=null){map.put("cateId",cateId);}
        if (tags!=null){map.put("tags",tags);}
        if (description!=null){map.put("description",description);}
        return Response.ok(uploadVideoApi.createUploadVideo(map));
    }

    @ApiOperation(value = "刷新视频上传凭证", notes = "刷新视频上传凭证", response = Response.class)
    @RequestMapping(value = "/refresh", method = RequestMethod.GET)
    public Response<String> refresh(
            @ApiParam(name = "videoId", value = "视频上传凭证", required = true) @RequestParam("videoId") String videoId
    ) {
        return Response.ok(uploadVideoApi.refreshUploadVideo(videoId));
    }


}
