/**
 * FileName: VideoFeignController
 * Author:   wenjunlong
 * Date:     2018/6/6 13:38
 * Description: 提供给其他微服务调用
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package com.yizhi.aliyun.application.controller;

import com.yizhi.aliyun.application.domain.GetPlayInfoRequest;
import com.yizhi.aliyun.application.domain.UploadVideoURLStreamVo;
import com.yizhi.aliyun.application.service.UploadVideoApi;
import com.yizhi.aliyun.application.service.VideoInfoApi;
import com.yizhi.aliyun.application.vo.UploadParamVo;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;

/**
 * 〈一句话功能简述〉<br>
 * 〈提供给其他微服务调用〉
 *
 * @author wenjunlong
 * @create 2018/6/6
 * @since 1.0.0
 */

@RestController
@RequestMapping(value = "/video")
public class VideoFeignController {

    @Autowired
    private UploadVideoApi uploadVideoApi;

    @Autowired
    private VideoInfoApi videoInfoApi;

    @ApiOperation(value = "视频上传", notes = "视频上传", response = Response.class)
    @RequestMapping(value = "/urlUpload", method = RequestMethod.POST)
    public String upload(
            @RequestBody UploadParamVo uploadParamVo
    ) {
        UploadVideoURLStreamVo uploadVideoURLStreamVo = new UploadVideoURLStreamVo();
        uploadVideoURLStreamVo.setTitle(uploadParamVo.getTitle());
        uploadVideoURLStreamVo.setFileName(uploadParamVo.getFileName());
        uploadVideoURLStreamVo.setURL(uploadParamVo.getUrl());
        if (uploadParamVo.getDescription() != null) {
            uploadVideoURLStreamVo.setDescription(uploadParamVo.getDescription());
        }
        if (uploadParamVo.getCateId() != null) {
            uploadVideoURLStreamVo.setCateId(uploadParamVo.getCateId());
        }
        if (uploadParamVo.getTags() != null) {
            uploadVideoURLStreamVo.setTags(uploadParamVo.getTags());
        }
        if (uploadParamVo.getCoverURL() != null) {
            uploadVideoURLStreamVo.setCoverURL(uploadParamVo.getCoverURL());
        }
        if (uploadParamVo.getIsShowWaterMark() != null) {
            uploadVideoURLStreamVo.setShowWaterMark(uploadParamVo.getIsShowWaterMark());
        }
        String result = uploadVideoApi.uploadURLStream(uploadVideoURLStreamVo);
        return result;
    }


    @ApiOperation(value = "获取视频播放地址", notes = "获取视频播放地址", response = Response.class)
    @RequestMapping(value = "/movieurls", method = RequestMethod.GET)
    public String movieurls(
            @ApiParam(name = "videoId", value = "视频ID", required = true) @RequestParam("videoId") String videoId
    ) {
        GetPlayInfoRequest getPlayInfoRequest = new GetPlayInfoRequest();
        getPlayInfoRequest.setVideoId(videoId);
        String result = videoInfoApi.GetPlayInfo(getPlayInfoRequest);
        return result;

    }

    /**
     * 获取文件的下载路径
     * @param sourceUrl oss的预览地址
     * @return
     */
    @GetMapping("/change/download")
    public String downloadObjectHeader(@RequestParam("sourceUrl") String sourceUrl){

        try {
            return uploadVideoApi.downloadObjectHeader(sourceUrl);
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        } catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return "";
    }
}
