package com.yizhi.aliyun.application.mq;

import com.yizhi.aliyun.application.service.DealMediaTranscode;
import com.yizhi.core.application.event.EventWrapper;
import com.yizhi.util.application.event.AssignmentMediaTranscodingEvent;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@RabbitListener(queues = "assignmentMediaTranscoding")
public class AssignmentTranscodingListener {

    @Autowired
    private DealMediaTranscode dealMediaTranscode;

    @RabbitHandler
    public void processBizEvent(EventWrapper<AssignmentMediaTranscodingEvent> eventWrapper) {
        try {
            dealMediaTranscode.addMedia(eventWrapper.getData().getFiles() ,eventWrapper.getData().getType());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }



}
