package com.yizhi.aliyun.application.service;

import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.mts.model.v20140618.AddMediaRequest;
import com.aliyuncs.mts.model.v20140618.AddMediaResponse;
import com.aliyuncs.mts.model.v20140618.QueryMediaListRequest;
import com.aliyuncs.mts.model.v20140618.QueryMediaListResponse;
import com.aliyuncs.profile.DefaultProfile;
import com.yizhi.aliyun.application.domain.MediaState;
import com.yizhi.aliyun.application.util.PropertiesUtil;
import com.yizhi.aliyun.application.vo.AddMediaResponseRecordVO;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.assignment.application.feign.AssignmentClient;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.documents.application.feign.DocumentClient;
import com.yizhi.forum.application.feign.remote.RemotePostsClient;
import com.yizhi.library.application.feign.StudentCaseClient;
import com.yizhi.util.application.constant.TpActivityType;
import com.yizhi.util.application.event.AssignmentMediaTranscodingEvent;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * @ClassName MediaTranscodeApi
 * @Description TODO
 * @Author shengchenglong
 * @DATE 2019-10-18 16:27
 * @Version 1.0
 */
@Component
public class DealMediaTranscode {

    @Autowired
    private PropertiesUtil propertiesUtil;

    private static final Logger LOGGER = LoggerFactory.getLogger(DealMediaTranscode.class);

    private String REGION = null;
    private String mtsEndpoint = null;

    //    private final String mnsEndPoint = "http://1955327038947993.mns.cn-shanghai.aliyuncs.com/";
    //Step 2.set accesskey & keySecret
    private String accessKeyId = null;
    private String accessKeySecret = null;

    private String workFlowId = null;
//    private final String mediaWorkflowQueueName = "wmy-transcoding";

    private final String media_hd_act_name = "Act-ss-mp4-hd";
    private final String media_sd_act_name = "Act-ss-mp4-sd";
    private final String media_ld_act_name = "Act-ss-mp4-ld";

    public static final List<String> media_vedio_suffix = new ArrayList<>();
    public static final List<String> media_music_suffix = new ArrayList<>();

    //    private CloudAccount account;
//    private CloudQueue queue;
    private DefaultAcsClient aliyunClient;

    @Autowired
    private IdGenerator idGenerator;
    @Autowired
    private AssignmentClient assignmentClient;
    @Autowired
    private DocumentClient documentClient;
    @Autowired
    private RedisCache redisCache;
    @Autowired
    private StudentCaseClient studentCaseClient;
    @Autowired
    private RemotePostsClient remotePostsClient;

    static {
        media_vedio_suffix.add("mp4");
        media_vedio_suffix.add("quicktime");
        media_vedio_suffix.add("3gp");
        media_vedio_suffix.add("avi");
        media_vedio_suffix.add("flv");
        media_vedio_suffix.add("f4v");
        media_vedio_suffix.add("mkv");
        media_vedio_suffix.add("mov");
        media_vedio_suffix.add("mpg");
        media_vedio_suffix.add("rmvb");
        media_vedio_suffix.add("vob");
        media_vedio_suffix.add("wmv");

        media_music_suffix.add("mp3");
        media_music_suffix.add("ape");
        media_music_suffix.add("aac");
        media_music_suffix.add("flac");
        media_music_suffix.add("wav");
        media_music_suffix.add("wma");
        media_music_suffix.add("ogg");
        media_music_suffix.add("m4a");
    }


    private void beforeTranscoding() {
//        account = new CloudAccount(accessKeyId, accessKeySecret, mnsEndPoint);
//        MNSClient mnsClient = account.getMNSClient();
//        queue = mnsClient.getQueueRef(mediaWorkflowQueueName);

        REGION = propertiesUtil.getPublicParam().get("REGION");
        mtsEndpoint = "mts." + REGION + ".aliyuncs.com";
        accessKeyId = propertiesUtil.getPublicParam().get("accessKeyId");
        accessKeySecret = propertiesUtil.getPublicParam().get("accessKeySecret");
        workFlowId = propertiesUtil.getPublicParam().get("workFlowId");

        try {
            DefaultProfile.addEndpoint(REGION, REGION, "Mts", mtsEndpoint);
        } catch (ClientException e) {
            System.out.print(ExceptionUtils.getStackTrace(e));
//            System.exit(1);
        }
        aliyunClient = new DefaultAcsClient(DefaultProfile.getProfile(REGION, accessKeyId, accessKeySecret));
    }

    /**
     * 添加媒体
     *
     * @param files
     * @throws ServerException
     * @throws ClientException
     */
    public void addMedia(List<AssignmentMediaTranscodingEvent.FileDTO> files, Integer type) {
        beforeTranscoding();
        List<Long> answerFileIds = new ArrayList<>();

        files.forEach(file -> {
            int suffixIndex = file.getOrrUrl().lastIndexOf(".");
            String suffix = file.getOrrUrl().substring(suffixIndex + 1);
            LOGGER.info("媒体转码：suffix- ：" + suffix);
            String type_suffix = null;

            AddMediaResponseRecordVO responseRecord = null;
            try {
                String fileURL = file.getOrrUrl().replaceAll("\\[", "【").replaceAll("\\]", "】");
                if (fileURL != null && !fileURL.equals("")) {
                    if (fileURL.startsWith("https")) {
                        fileURL = fileURL.replaceFirst("https", "http");
                    }
                }

                for (String s : media_vedio_suffix) {
                    if (s.equalsIgnoreCase(suffix)) {
                        type_suffix = "mp4";
                        break;
                    }
                }
                if (type_suffix == null) {
                    for (String s : media_music_suffix) {
                        if (s.equalsIgnoreCase(suffix)) {
                            type_suffix = "mp3";
                            break;
                        }
                    }
                }

                if (type_suffix == null) {
                    LOGGER.info("-----------------------------------未支持的格式，不进行转码操作-----------------------------------");
                    return;
                }

                AddMediaRequest request = new AddMediaRequest();
                request.setFileURL(fileURL);
                request.setMediaWorkflowId(workFlowId);
                AddMediaResponse response = aliyunClient.getAcsResponse(request);

                responseRecord = new AddMediaResponseRecordVO();
                responseRecord.setId(idGenerator.generate());
                responseRecord.setRelationId(file.getAssignmentAnswerFileId());
                responseRecord.setType(type);
                responseRecord.setMediaId(response.getMedia().getMediaId());
                responseRecord.setResponse(JSONObject.toJSONString(response));
                responseRecord.setHasProcessed(0);
                responseRecord.setSuffixType(type_suffix);
                responseRecord.insert();
                answerFileIds.add(file.getAssignmentAnswerFileId());

            } catch (ServerException e) {
                e.printStackTrace();
            } catch (ClientException e) {
                e.printStackTrace();
            }

        });

        LOGGER.info("answerFileIds: " + answerFileIds);
        LOGGER.info("type: " + type);
        if (CollectionUtils.isNotEmpty(answerFileIds)) {
            if (type.equals(TpActivityType.TYPE_ASSIGNMENT)) {
                // 通知作业微服务该附件是视频文件,等待转码
                assignmentClient.verifyVedio(answerFileIds);
                //通知资料微服务该附件是视频文件,等待转码
            } else if (type.equals(TpActivityType.TYPE_DOCUMENT)) {
                documentClient.verifyVedio(answerFileIds);
                //通知案例微服务该附件是视频/音频文件,等待转码
            } else if (type.equals(TpActivityType.TYPE_SELECTED_CASE)) {
                studentCaseClient.verifyVedio(answerFileIds);
                //通知论坛微服务该附件是视频/音频文件,等待转码
            }else if (type.equals(TpActivityType.TYPE_FORUM)) {
                remotePostsClient.verifyVideo(answerFileIds);
            }
        }

    }


//    public void getTranscodingResult() {
//        boolean flag = true;
//        List<Message> messageList;
//
//        try {
//            Thread.sleep(60000);
//        } catch (InterruptedException e) {
//            e.printStackTrace();
//        }
//
//        while (flag) {
//            messageList = queue.batchPopMessage(16, 30);
//            if (null == messageList || messageList.isEmpty()) {
//                flag = false;
//                return;
//            }
//            for (Message message : messageList) {
//                if (redisCache.hExisted("media:transcoding", message.getMessageId())) {
//                    continue;
//                }
//                redisCache.hset("media:transcoding", message.getMessageId(), "1", 10);
//                handlingMessage(message);
//            }
//        }
//    }
//
//    private void handlingMessage(Message message) {
//        String messageBody = message.getMessageBody();
//        ActivityDTO activityDTO = JSONObject.parseObject(messageBody, ActivityDTO.class);
//        if (activityDTO.getType().equals(ActivityType.Start.name())) {
//            //若工作流启动消息不希望处理，则直接删除
//            queue.deleteMessage(message.getReceiptHandle());
//        } else if (activityDTO.getType().equals(ActivityType.Report.name())) {
//            //获取媒体工作流执行信息
//            MediaWorkflowExecutionDTO mediaWorkflowExecutionDTO = activityDTO.getMediaWorkflowExecutionDTO();
//            //从媒体工作流中取活动列表
//            List<ActivityDTO> activityDTOS = mediaWorkflowExecutionDTO.getActivities();
//            //遍历活动列表，判断转码是否成功
//            if (null != activityDTOS) {
//                for (ActivityDTO activity : activityDTOS) {
//                    if (activity.getType().equals(ActivityType.Transcode.name())) {
//                        if (activity.getState().equals(ActivityState.Success.name())) {
//                            successTranscode(mediaWorkflowExecutionDTO, message.getReceiptHandle());
//                            break;
//                        }
//                    }
//                }
//            }
//        }
//    }
//
//    private void successTranscode(MediaWorkflowExecutionDTO mediaWorkflowExecutionDTO, String receiptHandle) {
//        //获取转码输出地址（OSS地址)
//        QueryMediaListRequest request = new QueryMediaListRequest();
//        request.setMediaIds(mediaWorkflowExecutionDTO.getMediaId());
//        request.setIncludePlayList(true);
//        try {
//            QueryMediaListResponse response = aliyunClient.getAcsResponse(request);
//            List<QueryMediaListResponse.Media> list = response.getMediaList();
//            QueryMediaListResponse.Media media = list.get(0);
//            if (media.getPublishState().equals(MediaState.Published.name())) {
//                List<QueryMediaListResponse.Media.Play> playList = media.getPlayList();
//                if (null != playList) {
//                    Map<String, String> map = new HashMap<>();
//
//                    AddMediaResponseRecord responseRecord = new AddMediaResponseRecord();
//                    responseRecord.setMediaId(mediaWorkflowExecutionDTO.getMediaId());
//                    responseRecord = responseRecord.selectOne(new EntityWrapper(responseRecord));
//
//                    if (responseRecord != null) {
//                        map.put("id", String.valueOf(responseRecord.getRelationId()));
//                        for (QueryMediaListResponse.Media.Play play : playList) {
//                            //遍历转码输出地址
//                            if (play.getActivityName().equals(media_sd_act_name)) {
//                                map.put("sd", play.getFile1().getURL());
//                            } else if (play.getActivityName().equals(media_ld_act_name)) {
//                                map.put("ld", play.getFile1().getURL());
//                            } else if (play.getActivityName().equals(media_hd_act_name)) {
//                                map.put("hd", play.getFile1().getURL());
//                            }
//                        }
//                        assignmentClient.updateVedioTranscodeUrl(map);
//                    }
//                }
//            }
//        } catch (ServerException e) {
//            LOGGER.error(ExceptionUtils.getStackTrace(e));
//        } catch (ClientException e) {
//            LOGGER.error(ExceptionUtils.getStackTrace(e));
//        }
//
//        //如果是report消息，需要从队列中删除，否则会一直在队列中
//        queue.deleteMessage(receiptHandle);
//    }

    /**
     * 拿取媒体id查询转码后的地址，更新到相关的服务，并记录已处理
     *
     * @return
     */
    public boolean dealFinishedTranscoding(AddMediaResponseRecordVO record) {
        beforeTranscoding();
        QueryMediaListRequest request = new QueryMediaListRequest();
        request.setMediaIds(record.getMediaId());
        request.setIncludePlayList(true);
        try {
            QueryMediaListResponse response = aliyunClient.getAcsResponse(request);
            List<QueryMediaListResponse.Media> list = response.getMediaList();
            QueryMediaListResponse.Media media = list.get(0);
            if (media.getPublishState().equals(MediaState.Published.name())) {
                List<QueryMediaListResponse.Media.Play> playList = media.getPlayList();
                if (null != playList) {
                    Map<String, String> map = new HashMap<>();
                    map.put("id", String.valueOf(record.getRelationId()));
                    for (QueryMediaListResponse.Media.Play play : playList) {
                        if (play.getFormat().equalsIgnoreCase("mp3") && record.getSuffixType().equalsIgnoreCase("mp3")) {
                            map.put("sd", play.getFile1().getURL().replaceAll("http", "https"));
                            break;
                        } else if (play.getFormat().equalsIgnoreCase("mp4") && record.getSuffixType().equalsIgnoreCase("mp4")) {
                            map.put("sd", play.getFile1().getURL().replaceAll("http", "https"));
                            break;
                        }
                    }

                    //对阿里云转码后的标清地址进行非空判断
                    if(map.get("sd")==null||"".equals(map.get("sd"))){
                        return false;
                    }

                    boolean flag = notifyBiz(record.getType(), map);

                    if (flag) {
                        AddMediaResponseRecordVO responseRecord = new AddMediaResponseRecordVO();
                        responseRecord.setId(record.getId());
                        responseRecord.setHasProcessed(1);
                        responseRecord.setProcessTime(new Date());
                        return responseRecord.updateById();
                    }
                }
            }
        } catch (ServerException e) {
            LOGGER.error(ExceptionUtils.getStackTrace(e));
        } catch (ClientException e) {
            LOGGER.error(ExceptionUtils.getStackTrace(e));
        }
        return false;
    }


    boolean notifyBiz(Integer type, Map<String, String> map) {
        boolean flag = false;
        if (type == TpActivityType.TYPE_ASSIGNMENT) {
            flag = assignmentClient.updateVedioTranscodeUrl(map);
        } else if (type == TpActivityType.TYPE_DOCUMENT) {
            flag = documentClient.updateVedioTranscodeUrl(map);
        } else if (type.equals(TpActivityType.TYPE_SELECTED_CASE)) {
            flag = studentCaseClient.updateTranscodeUrl(map);
        }else if (type.equals(TpActivityType.TYPE_FORUM)) {
            System.out.println("论坛传参："+ map.toString());
            flag = remotePostsClient.updateVideoTranscodeUrl(map);
        }
        return flag;
    }
}
