package com.yizhi.aliyun.application.service;


import com.yizhi.aliyun.application.domain.UploadVideoURLStreamVo;
import com.yizhi.aliyun.application.domain.UploadVideoVo;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.Map;

public interface UploadVideoApi {

    /**
     * 上传本地文件到阿里云服务器
     * @param uploadVideoVo 上传文件属性对象 具体参数注释看对象类
     * @return UploadVideoBaseResponse
     */
     String UploadVideoLocal(UploadVideoVo uploadVideoVo);

    /**
     * 上传网络文件到阿里云服务器
     * @param uploadVideoURLStreamVo 网络文件属性对象 具体参数注释看对象类
     * @return UploadVideoBaseResponse
     */
     String uploadURLStream(UploadVideoURLStreamVo uploadVideoURLStreamVo);


    /**
     * 获取视频上传凭证和地址
     * @param map  文件属性
     * @return  String 返回的结果
     */
    String createUploadVideo(Map<String, Object> map);

    /**
     * 刷新视频上传凭证
     * @param videoId  刷新凭证
     * @return  String  执行结果信息
     */
    String refreshUploadVideo(String videoId);


    String downloadObjectHeader(String sourceUrl) throws UnsupportedEncodingException, MalformedURLException;


}
