package com.yizhi.aliyun.application.service;


import com.yizhi.aliyun.application.domain.GetPlayInfoRequest;
import com.yizhi.aliyun.application.domain.GetVideoListRequest;
import com.yizhi.aliyun.application.domain.UpdateVideoInfoRequest;

public interface VideoInfoApi {

    /**
     * 获取视频信息
     * @param videoId 视频id
     * @return  String  json结果集
     */
    String getVideoInfo(String videoId);

    /**
     * 修改视频信息
     * @param updateVideoInfoRequest  修改视频信息对象 具体注释看类
     * @return String json结果集
     */

    String updateVideoInfo(UpdateVideoInfoRequest updateVideoInfoRequest);

    /**
     * 删除视频
     * @param VideoIds 视频id  v
     * @return  String json结果集
     */
    String deleteVideo(String VideoIds);


    /**
     * 获取视频信息列表
     * @param getVideoListRequest  获取视频list请求对象
     * @return String json结果集
     */
    String getVideoList(GetVideoListRequest getVideoListRequest);

    /**
     *  获取视频播放地址
     * @param getPlayInfoRequest  获取视频播放地址请求对象
     * @return String json结果集
     */
    String GetPlayInfo(GetPlayInfoRequest getPlayInfoRequest);
}
