package com.yizhi.aliyun.application.service.impl;


import com.yizhi.aliyun.application.domain.GetPlayInfoRequest;
import com.yizhi.aliyun.application.domain.GetVideoListRequest;
import com.yizhi.aliyun.application.domain.UpdateVideoInfoRequest;
import com.yizhi.aliyun.application.service.VideoInfoApi;
import com.yizhi.aliyun.application.util.PropertiesUtil;
import com.yizhi.aliyun.application.util.VideoRequestUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;

import static org.apache.commons.lang3.CharEncoding.UTF_8;

@Service
public class VideoInfoApiImpl implements VideoInfoApi {

    @Autowired
    PropertiesUtil propertiesUtil;

    @Override
    public String getVideoInfo(String videoId) {

        Map<String, String> privateParams = new LinkedHashMap<String, String>();
        privateParams.put("VideoId",videoId);
        privateParams.put("Action", "GetVideoInfo");
        privateParams.put("access_key_id", propertiesUtil.getPublicParam().get(""));
        privateParams.put("access_key_secret", propertiesUtil.getPublicParam().get(""));
        String url = VideoRequestUtil.getOpenAPIURL(privateParams);
        String result ="";
        try {
            result = httpGet(url);
        }catch (Exception e){
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public String updateVideoInfo(UpdateVideoInfoRequest updateVideoInfoRequest) {
        Map<String, String> privateParams = new LinkedHashMap<String, String>();
        privateParams.put("VideoId",updateVideoInfoRequest.getVideoId());
        privateParams.put("Action", updateVideoInfoRequest.getAction());
        if (updateVideoInfoRequest.getTitle()!=null) {privateParams.put("Title", updateVideoInfoRequest.getTitle()); }
        if (updateVideoInfoRequest.getDescription()!=null) {privateParams.put("Description", updateVideoInfoRequest.getDescription()); }
        if (updateVideoInfoRequest.getCoverURL()!=null) {privateParams.put("CoverURL", updateVideoInfoRequest.getCoverURL()); }
        if (updateVideoInfoRequest.getCateId()!=null) {privateParams.put("CateId", updateVideoInfoRequest.getCateId()); }
        if (updateVideoInfoRequest.getTags()!=null) {privateParams.put("Tags", updateVideoInfoRequest.getTags()); }
        String url = VideoRequestUtil.getOpenAPIURL(privateParams);
        String result ="";
        try {
            result = httpGet(url);
        }catch (Exception e){
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public String deleteVideo(String videoId) {
        Map<String, String> privateParams = new LinkedHashMap<String, String>();
        privateParams.put("VideoIds",videoId);
        privateParams.put("Action", "DeleteVideo");
        String url = VideoRequestUtil.getOpenAPIURL(privateParams);
        String result ="";
        try {
            result = httpGet(url);
        }catch (Exception e){
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public String getVideoList(GetVideoListRequest getVideoListRequest) {
        Map<String, String> privateParams = new LinkedHashMap<String, String>();
        privateParams.put("Action", getVideoListRequest.getAction());
        if (getVideoListRequest.getStatus()!=null) {privateParams.put("Status", getVideoListRequest.getStatus()); }
        if (getVideoListRequest.getStartTime()!=null) {privateParams.put("StartTime", getVideoListRequest.getStartTime()); }
        if (getVideoListRequest.getEndTime()!=null) {privateParams.put("EndTime", getVideoListRequest.getEndTime()); }
        if (getVideoListRequest.getCateId()!=null) {privateParams.put("CateId", getVideoListRequest.getCateId()); }
        if (getVideoListRequest.getPageNo()!=null) {privateParams.put("PageNo", getVideoListRequest.getPageNo().toString()); }
        if (getVideoListRequest.getPageSize()!=null) {privateParams.put("PageSize", getVideoListRequest.getPageSize().toString()); }
        if (getVideoListRequest.getSortBy()!=null) {privateParams.put("SortBy", getVideoListRequest.getSortBy()); }
        String url = VideoRequestUtil.getOpenAPIURL(privateParams);
        String result ="";
        try {
             result = httpGet(url);
        }catch (Exception e){
            e.printStackTrace();
        }
        return result;
    }


    @Override
    public String GetPlayInfo(GetPlayInfoRequest getPlayInfoRequest) {
        Map<String, String> privateParams = new LinkedHashMap<String, String>();
        privateParams.put("Action", getPlayInfoRequest.getAction());
        privateParams.put("VideoId", getPlayInfoRequest.getVideoId());
        if (getPlayInfoRequest.getFormats()!=null) {privateParams.put("Formats", getPlayInfoRequest.getFormats()); }
        if (getPlayInfoRequest.getAuthTimeout()!=null) {privateParams.put("AuthTimeout", getPlayInfoRequest.getAuthTimeout()); }
        if (getPlayInfoRequest.getStreamType()!=null) {privateParams.put("StreamType", getPlayInfoRequest.getStreamType()); }
        if (getPlayInfoRequest.getDefinition()!=null) {privateParams.put("Definition", getPlayInfoRequest.getDefinition()); }
        String url = VideoRequestUtil.getOpenAPIURL(privateParams);
        String result ="";
        try {
            result = httpGet(url);
        }catch (Exception e){
            e.printStackTrace();
        }
        return result;
    }

    private static String httpGet(String url) throws IOException {
    /*
    * Read and covert a inputStream to a String.
    * Referred this:
    * http://stackoverflow.com/questions/309424/read-convert-an-inputstream-to-a-string
    */
        @SuppressWarnings("resource")
        Scanner s = new Scanner(new URL(url).openStream(), UTF_8).useDelimiter("\\A");
        try {
            String resposne = s.hasNext() ? s.next() : "true";
            return resposne;
        } finally {
            s.close();
        }
    }
}
