package com.yizhi.aliyun.application.service.impl;

import com.alibaba.fastjson.JSON;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.CopyObjectRequest;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.vod.upload.impl.UploadVideoImpl;
import com.aliyun.vod.upload.req.UploadURLStreamRequest;
import com.aliyun.vod.upload.req.UploadVideoRequest;
import com.aliyun.vod.upload.resp.UploadURLStreamResponse;
import com.aliyun.vod.upload.resp.UploadVideoResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.vod.model.v20170321.CreateUploadVideoRequest;
import com.aliyuncs.vod.model.v20170321.CreateUploadVideoResponse;
import com.aliyuncs.vod.model.v20170321.RefreshUploadVideoRequest;
import com.aliyuncs.vod.model.v20170321.RefreshUploadVideoResponse;
import com.yizhi.aliyun.application.domain.UploadVideoURLStreamVo;
import com.yizhi.aliyun.application.domain.UploadVideoVo;
import com.yizhi.aliyun.application.service.UploadVideoApi;
import com.yizhi.aliyun.application.util.PropertiesUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;


@Service
public class VideoUploadImpl implements UploadVideoApi {

    @Autowired
    PropertiesUtil propertiesUtil;

    @Override
    public String UploadVideoLocal(UploadVideoVo uploadVideoVo) {

        Map<String,String> map = propertiesUtil.getPublicParam();
        String accessKeyId = map.get("accessKeyId");
        String accessKeySecret = map.get("accessKeySecret");

        UploadVideoRequest request = new UploadVideoRequest(accessKeyId, accessKeySecret, uploadVideoVo.getTitle(), uploadVideoVo.getFileName());
        if(uploadVideoVo.getPartSize()!=null){ request.setPartSize(uploadVideoVo.getPartSize());}  //可指定分片上传时每个分片的大小，默认为10M字节
        if(uploadVideoVo.getTaskNum()!=null){ request.setTaskNum(uploadVideoVo.getTaskNum()); } //可指定分片上传时的并发线程数，默认为1，(注：该配置会占用服务器CPU资源，需根据服务器情况指定）
        if(uploadVideoVo.getShowWaterMark()!=null){request.setIsShowWaterMark(uploadVideoVo.getShowWaterMark());}   //是否使用默认水印
        if(uploadVideoVo.getCallback()!=null){request.setCallback(uploadVideoVo.getCallback());}   //设置上传完成后的回调URL(可选)
        if(uploadVideoVo.getCateId()!=null){request.setCateId(uploadVideoVo.getCateId());}   //视频分类ID(可选)
        if(uploadVideoVo.getTags()!=null){request.setTags(uploadVideoVo.getTags());}   //视频标签,多个用逗号分隔(可选)

        if(uploadVideoVo.getDescription()!=null){request.setDescription(uploadVideoVo.getDescription());}   //视频描述(可选)
        if(uploadVideoVo.getCoverURL()!=null){request.setCoverURL(uploadVideoVo.getCoverURL());}   //封面图片(可选)

        UploadVideoImpl uploader = new UploadVideoImpl();
        UploadVideoResponse response = uploader.uploadVideo(request);
        String result = JSON.toJSONString(response);

        return result;
    }


    @Override
    public String uploadURLStream(UploadVideoURLStreamVo uploadVideoURLStreamVo) {

        Map<String,String> map = propertiesUtil.getPublicParam();
        String accessKeyId = map.get("accessKeyId");
        String accessKeySecret = map.get("accessKeySecret");

        UploadURLStreamRequest request = new UploadURLStreamRequest(accessKeyId, accessKeySecret,uploadVideoURLStreamVo.getTitle(), uploadVideoURLStreamVo.getFileName(), uploadVideoURLStreamVo.getURL());


        if(uploadVideoURLStreamVo.getShowWaterMark()!=null){request.setShowWaterMark(uploadVideoURLStreamVo.getShowWaterMark());}   //是否使用默认水印
        if(uploadVideoURLStreamVo.getCallback()!=null){request.setCallback(uploadVideoURLStreamVo.getCallback());}   //设置上传完成后的回调URL(可选)
        if(uploadVideoURLStreamVo.getCateId()!=null){request.setCateId(uploadVideoURLStreamVo.getCateId());}   //视频分类ID(可选)
        if(uploadVideoURLStreamVo.getTags()!=null){request.setTags(uploadVideoURLStreamVo.getTags());}   //视频标签,多个用逗号分隔(可选)

        if(uploadVideoURLStreamVo.getDescription()!=null){request.setDescription(uploadVideoURLStreamVo.getDescription());}   //视频描述(可选)
        if(uploadVideoURLStreamVo.getCoverURL()!=null){request.setCoverURL(uploadVideoURLStreamVo.getCoverURL());}   //封面图片(可选)

        UploadVideoImpl uploader = new UploadVideoImpl();
        UploadURLStreamResponse response = uploader.uploadURLStream(request);

        String result = JSON.toJSONString(response);
        return result;
    }



    @Override
    public String createUploadVideo(Map<String,Object> map) {

        String result = "";
        CreateUploadVideoRequest request = new CreateUploadVideoRequest();
        CreateUploadVideoResponse response = null;
        try {
            /*必选，视频源文件名称（必须带后缀, 支持 ".3gp", ".asf", ".avi", ".dat", ".dv", ".flv", ".f4v", ".gif", ".m2t", ".m3u8", ".m4v", ".mj2", ".mjpeg", ".mkv", ".mov", ".mp4", ".mpe", ".mpg", ".mpeg", ".mts", ".ogg", ".qt", ".rm", ".rmvb", ".swf", ".ts", ".vob", ".wmv", ".webm"".aac", ".ac3", ".acm", ".amr", ".ape", ".caf", ".flac", ".m4a", ".mp3", ".ra", ".wav", ".wma"）*/
            request.setFileName(map.get("fileName").toString());
            //必选，视频标题
            request.setTitle(map.get("title").toString());
            if (map.containsKey("cateId")){
                //可选，分类ID
                request.setCateId((Integer) map.get("cateId"));
            }
            if (map.containsKey("tags")){
                //可选，视频标签，多个用逗号分隔
                request.setTags(map.get("tags").toString());
            }
            if (map.containsKey("description")){
                //可选，视频描述
                request.setDescription(map.get("description").toString());
            }

            response = this.getAliyunClient().getAcsResponse(request);
        } catch (ServerException e) {
            System.out.println("CreateUploadVideoRequest Server Exception:");
            e.printStackTrace();
            Map<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("msg","CreateUploadVideoRequest Server Exception:");
            result = JSON.toJSONString(resultMap);
            return result;
        } catch (ClientException e) {
            System.out.println("CreateUploadVideoRequest Client Exception:");
            e.printStackTrace();
            Map<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("msg","CreateUploadVideoRequest Client Exception:");
            result = JSON.toJSONString(resultMap);
        }
        result = JSON.toJSONString(response);
        return result;
    }

    @Override
    public String refreshUploadVideo(String videoId) {
        RefreshUploadVideoRequest request = new RefreshUploadVideoRequest();
        RefreshUploadVideoResponse response = null;
        try {
            request.setVideoId(videoId);
            response = this.getAliyunClient().getAcsResponse(request);
        } catch (ServerException e) {
            System.out.println("RefreshUploadVideoRequest Server Exception:");
            e.printStackTrace();
            return "RefreshUploadVideoRequest Server Exception:";
        } catch (ClientException e) {
            System.out.println("RefreshUploadVideoRequest Client Exception:");
            e.printStackTrace();
            return "RefreshUploadVideoRequest Client Exception:";
        }
        return "success";
    }

    @Override
    public String downloadObjectHeader(String sourceUrl) throws UnsupportedEncodingException, MalformedURLException {
        Map<String,String> map = propertiesUtil.getPublicParam();
        String accessKeyId = map.get("accessKeyId");
        String accessKeySecret = map.get("accessKeySecret");
        String bucket = map.get("bucket");
        String endpoint = map.get("endpoint");
        URL url = new URL(sourceUrl);
        /*System.out.println("域名（不包含http://部分）="+url.getHost());
        System.out.println("域名后面的路径（**.com后面的内容）="+url.getPath());
        System.out.println("？号后面的内容="+url.getQuery());
        System.out.println("协议（http或者https）="+url.getProtocol());
        System.out.println("端口（http=80，https=443）="+url.getDefaultPort());
        System.out.println("Port（返回负1，不知道为啥）="+url.getPort());*/
        String sourceKey = url.getPath();
        Path path = Paths.get(sourceKey);
        //String destinationKey = path.getFileName().toString(); // todo 需要改文件名参考main函数的处理方式
        String destinationKey = "/download"+sourceKey;
        OSSClient ossClient = new OSSClient(endpoint, accessKeyId, accessKeySecret);
        CopyObjectRequest request = new CopyObjectRequest(bucket, sourceKey,
                bucket, destinationKey);
        ObjectMetadata meta = ossClient.getObjectMetadata(bucket, sourceKey);
        meta.setContentDisposition("attachment; filename=\"" + URLEncoder.encode(path.getFileName().toString(), "UTF-8") + "\"");
        meta.setContentEncoding("utf-8");
        request.setNewObjectMetadata(meta);
        //修改元信息。
        ossClient.copyObject(request);
        // 关闭OSSClient。
        ossClient.shutdown();
        return sourceUrl.replace(sourceKey, destinationKey);
    }

    public static void main(String[] args) throws MalformedURLException {
        String urlStr = "https://test-wmy-transcoding-origin.oss-cn-hangzhou.aliyuncs.com/document/rc-upload-1575553047642-2.1.jpg?jj=0";
        URL url = new URL(urlStr);
        String host = url.getHost();// 获取主机名
        System.out.println("Host="+url.getHost());
        String pathStr = url.getPath();
        System.out.println("Path="+pathStr);
        Path path = Paths.get(pathStr);
        System.out.println(path.getFileName());
        System.out.println(path.getParent());
        String changeStr = path.getParent()+"/"+"change_"+path.getFileName();
        System.out.println("Query="+url.getQuery());
        System.out.println("Protocol="+url.getProtocol());
        System.out.println("DefaultPort="+url.getDefaultPort());
        System.out.println("Port="+url.getPort());
        System.out.println(urlStr.replace(pathStr, changeStr));
    }

    private DefaultAcsClient getAliyunClient(){
        Map<String,String> map = propertiesUtil.getPublicParam();
        String accessKeyId = map.get("accessKeyId");
        String accessKeySecret = map.get("accessKeySecret");
        DefaultAcsClient aliyunClient;
        aliyunClient = new DefaultAcsClient(
                DefaultProfile.getProfile("cn-shanghai",accessKeyId,accessKeySecret));
        return aliyunClient;
    }
}
