package com.yizhi.logging.config;

import org.apache.commons.lang3.StringUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;

/**
 * @ClassName RequestlogRepository
 * @Description 仅仅对controller层方法参数中的LocalDateTime生效，不适用reqestBody的对象中的属性，对象中的属性可以自定义jackson的转换来实现。
 * @Author shengchenglong
 * @DATE 2021/1/12 10:48
 * @Version 1.0
 */
@Component
public class LocalDateTimeConverter implements Converter<String, LocalDateTime> {

    @Override
    public LocalDateTime convert(String source) {
        if (StringUtils.isBlank(source)) {
            return null;
        }
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(Long.parseLong(source)), ZoneId.of("+8"));
    }
}