package com.yizhi.logging.domain;

import java.io.Serializable;
import java.time.LocalDateTime;

import javax.persistence.Id;

import org.springframework.data.mongodb.core.mapping.Document;

import lombok.Data;

/**
 * @ClassName RequestLog
 * @Description TODO
 * @Author shengchenglong
 * @DATE 2021/1/11 15:37
 * @Version 1.0
 */
@Document("requestLog")
@Data
public class RequestLog implements Serializable {

    private static final long serialVersionUID = -1;

    @Id
    private String id;

    private String requestId;

    /********** request *************************/
    private String requestLocalIp;

    private String requestRemoteIp;

    private String requestRemoteIpPlace;

    private String requestUrl;

    private String requestUri;

    private String requestMethod;

    private String requestParams;

    private String requestBody;

    /********** response *************************/

    private Integer responseStatus4Container;

    private String responseBody4Container;

    private Integer responseStatus;

    private String responseBody;

    private String errorMsg;

    /********** common *************************/
    private Long accountId;

    private Long orgId;

    private Long siteId;

    private Long companyId;

    private LocalDateTime startTime;

    private LocalDateTime endTime;

    private Long millis;

    private String terminalType;
}
