package com.yizhi.logging.mq;

import com.yizhi.logging.domain.RequestLog;
import com.yizhi.logging.dto.RequestLogDTO;
import com.yizhi.logging.repository.RequestLogRepository;
import com.yizhi.util.application.constant.QueueConstant;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @ClassName GatewayLogMq
 * @Description TODO
 * @Author shengchenglong
 * @DATE 2021/1/12 10:51
 * @Version 1.0
 */
@Component
@RabbitListener(queues = QueueConstant.REQUEST_LOG_QUEUE)
@Slf4j
public class RequestLogListener {

    @Autowired
    private RequestLogRepository requestLogRepository;

    @RabbitHandler
    public void saveLog(RequestLogDTO requestLogDTO) {
    	log.debug("======save log");
        RequestLog requestLog = new RequestLog();
        BeanUtils.copyProperties(requestLogDTO, requestLog);
        requestLogRepository.save(requestLog);
    }

}