package com.yizhi.logging.servicve;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.yizhi.logging.domain.AuthResource;
import com.yizhi.logging.repository.AuthResourceRepository;

import lombok.extern.slf4j.Slf4j;

/**
 * @ClassName RequestLogServiceImpl
 * @Description 请求日志
 * @Author shengchenglong
 * @DATE 2021/1/25 10:41
 * @Version 1.0
 */
@Service
@Slf4j
public class AuthResourceServiceImpl implements AuthResourceService {

    @Autowired
    private AuthResourceRepository authResourceRepository;

    @Override
    public String getNameByUrl(String uri) {
        if (StringUtils.isBlank(uri)) {
            return null;
        }
        String[] split = uri.split("/");
        if (split.length > 2) {
            uri = uri.substring(split[1].length() + 1);
        }
        log.info("==========uri {}", uri);
        AuthResource authResource = authResourceRepository.findFirstByUrl(uri);
        if (authResource != null) {
            return authResource.getName();
        }
        return null;
    }
}
