package com.yizhi.logging.servicve;

import java.time.LocalDateTime;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.yizhi.logging.domain.RequestLog;
import com.yizhi.logging.repository.RequestLogRepository;

import lombok.extern.slf4j.Slf4j;

/**
 * @ClassName RequestLogServiceImpl
 * @Description 请求日志
 * @Author shengchenglong
 * @DATE 2021/1/25 10:41
 * @Version 1.0
 */
@Service
@Transactional
@Slf4j
public class RequestLogServiceImpl implements RequestLogService {

    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private RequestLogRepository requestLogRepository;

    @Override
    public Page<RequestLog> page(LocalDateTime startTime, LocalDateTime endTime, Integer pageNo, Integer pageSize) {

    	log.info("start {} end {}", startTime, endTime);
        Sort sort = Sort.by("startTime").descending();
        Pageable pageable = PageRequest.of(pageNo - 1, pageSize, sort);

        Criteria criteria = new Criteria();
        if(startTime != null && endTime != null) {
        	criteria.andOperator(Criteria.where("startTime").gte(startTime), Criteria.where("startTime").lte(endTime));
        }else if(startTime != null) {
            criteria.and("startTime").gte(startTime);
        }else if(endTime != null){
            criteria.and("startTime").lte(endTime);
        }

        Query query = Query.query(criteria);
        long t1 = System.currentTimeMillis();
//        long count = mongoTemplate.count(query, RequestLog.class);
        long count = 500000;
        long t2 = System.currentTimeMillis();
        log.info("total num {},spend {}", count, t2-t1);
        query.with(pageable);
        List<RequestLog> list = mongoTemplate.find(query, RequestLog.class);
        long t3 = System.currentTimeMillis();
        log.info("page query spend {}", t3-t2);
        return new PageImpl(list, pageable, count);
    }

    @Override
    public RequestLog findById(String id) {
        return requestLogRepository.findById(id).get();
    }
}
