package com.yizhi.logging.util;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yizhi.core.application.cache.RedisCache;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import javax.annotation.PostConstruct;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

/**
 * @ClassName IpUtil
 * @Description TODO
 * @Author shengchenglong
 * @DATE 2021/1/25 20:33
 * @Version 1.0
 */
@Component
@ConditionalOnBean(RedisCache.class)
public class IpUtil {

    private static final String IP_URL_PCONLINE = "http://whois.pconline.com.cn/ipJson.jsp?ip=%s&json=true";

    private static final String IP_URL_126 = "https://ip.ws.126.net/ipquery?ip=%s";

    private static final String IP_URL_IPAPI = "http://ip-api.com/json/%s?lang=zh-CN";

    private static final String REDIS_CACHE_KEY = "IP_ADDR";

    private static RedisCache redisCache;

    @Autowired
    private RedisCache redisCacheTmp;

    @PostConstruct
    public void init() {
        IpUtil.redisCache = redisCacheTmp;
    }

    /**
     * 根据ip获取详细地址
     */
    public static String getHttpCityInfo(String ip) {
        String addr = getFromRedis(ip);
        if (!StringUtils.isEmpty(addr)) {
            return addr;
        }

        addr = getFromPconline(ip);

        if (StringUtils.isEmpty(addr)) {
            addr = getFrom126(ip);
        }

        if (StringUtils.isEmpty(addr)) {
            addr = getFromIpApi(ip);
        }
        set2Redis(ip, addr);
        return addr;
    }

    private static String getFromPconline(String ip) {
        try {
            String api = String.format(IP_URL_PCONLINE, ip);
            JSONObject json = JSON.parseObject(HttpUtil.get(api));
            return String.valueOf(json.get("addr"));
        } catch (Exception e) {
            return null;
        }
    }

    private static String getFrom126(String ip) {
        try {
            String api = String.format(IP_URL_126, ip);
            String res = HttpUtil.get(api);
            //本质上获得的是Rhino的接口在 JDK6.0后被集成  详细调用方法可以查看rhino的官网
            //获取脚本引擎管理器  接着获得 对应引擎的对象
            ScriptEngineManager manager = new ScriptEngineManager();
            ScriptEngine scriptEngine = manager.getEngineByName("javascript");

            scriptEngine.eval(res);
            String addr = String.valueOf(scriptEngine.get("lo")) + " | " + String.valueOf(scriptEngine.get("lo"));
            return addr;
        } catch (ScriptException e) {
            return null;
        }
    }

    private static String getFromIpApi(String ip) {
        try {
            String api = String.format(IP_URL_IPAPI, ip);
            String res = HttpUtil.get(api);
            JSONObject jsonObject = JSON.parseObject(res);
            return jsonObject.get("city") + " | " + jsonObject.get("isp");
        } catch (Exception e) {
            return null;
        }
    }

    private static String getFromRedis(String ip) {
        Object object = redisCache.hget(REDIS_CACHE_KEY, ip);
        if (object == null) {
            return null;
        }
        return String.valueOf(object);
    }

    public static void set2Redis(String ip, String addr) {
        redisCache.hset(REDIS_CACHE_KEY, ip, addr, 24 * 60 * 60);
    }


}
