package com.yizhi.logging.util;

import com.yizhi.util.application.page.PageInfo;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;

import java.util.ArrayList;
import java.util.List;

/**
 * @ClassName PageInfoUtil
 * @Description TODO
 * @Author shengchenglong
 * @DATE 2021/1/25 11:11
 * @Version 1.0
 */
public class PageInfoUtil {

    public static PageInfo of(Integer pageNo, Integer pageSize, Integer total, List list) {
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageNo(pageNo);
        pageInfo.setPageSize(pageSize);
        pageInfo.setPageRecords(total);
        pageInfo.setRecords(list);
        return pageInfo;
    }

    public static PageInfo of(Page page) {
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageNo(page.getNumber() + 1);
        pageInfo.setPageSize(page.getSize());
        pageInfo.setPageRecords(Math.toIntExact(page.getTotalElements()));
        pageInfo.setRecords(page.getContent());
        return pageInfo;
    }

    public static PageInfo transfer(PageInfo originPage, Class destClass) {
        if (originPage == null || CollectionUtils.isEmpty(originPage.getRecords())) {
            return originPage;
        }
        List list = originPage.getRecords();
        List destList = new ArrayList(list.size());
        try {
            Object destObj;
            for (Object origin : list) {
                destObj = destClass.newInstance();
                BeanUtils.copyProperties(origin, destObj);
                destList.add(destObj);
            }
        } catch (InstantiationException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        originPage.setRecords(destList);
        return originPage;
    }

}
