package com.yizhi.application.caseLibrary.controller;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.library.application.feign.CommentManageClient;
import com.yizhi.library.application.vo.CommentReplyVO;
import com.yizhi.library.application.vo.CommentVO;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.enums.i18n.Constants;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Ding
 * @className CommentManageController
 * @description TODO
 * @date 2019/7/15
 **/
@Api(tags = "评分管理接口", description = "评分管理接口")
@RestController
@RequestMapping("/manage/caseLibrary/comment")
public class CommentManageController {

    private static final Logger LOGGER = LoggerFactory.getLogger(CommentManageController.class);

    @Autowired
    private CommentManageClient commentManageClient;

    @ApiOperation(value = "获取评论管理列表", notes = "获取评论管理列表", response = CommentVO.class)
    @GetMapping("/list")
    public Response<CommentVO> getCommentManageList(@ApiParam(value = "学员案例id", required = true) @RequestParam(name = "studentCaseId", required = true) Long studentCaseId,
                                             @ApiParam(value = "评论人用户名或者姓名/需求改了不需要模糊查询了", required = false) @RequestParam(name = "name", required = false) String name,
                                             @ApiParam(value = "状态/需求改了,不需要模糊查询了", required = false) @RequestParam(name = "state", required = false) Integer state,
                                             @ApiParam(value = "当前第几页", required = true) @RequestParam(name = "pageNo", required = true) Integer pageNo,
                                             @ApiParam(value = "每页条数", required = true) @RequestParam(name = "pageSize", required = true) Integer pageSize) {

        try {
            if (StringUtils.isNotBlank(name)) {
                name = name.trim();
            }
            Page<CommentVO> page = commentManageClient.getCommentManageList(studentCaseId, name, state, pageNo, pageSize);
            Map<String, Integer> pageMap = new HashMap<>(3);
            pageMap.put("pageNo", pageNo);
            pageMap.put("pageSize", pageSize);
            if (null != page) {
                pageMap.put("total", page.getTotal());
            }
            return Response.ok(page, pageMap);
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "下载评论信息", notes = "下载评论信息")
    @GetMapping("/downloadList")
    public Response<String> downloadList(@ApiParam(value = "学员案例id", required = true) @RequestParam(name = "studentCaseId", required = true) Long studentCaseId,
                                     @ApiParam(value = "评论人用户名或者姓名", required = false) @RequestParam(name = "name", required = false) String name,
                                     @ApiParam(value = "状态", required = false) @RequestParam(name = "state", required = false) Integer state) {

        try {
            if (StringUtils.isNotBlank(name)) {
                name = name.trim();
            }
            String serialNo = commentManageClient.downloadList(studentCaseId, name, state);
            return Response.ok("导入成功," + " " + "编号:" + serialNo);
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "获取评论回复列表", notes = "获取评论回复列表", response = CommentReplyVO.class)
    @GetMapping("/replyList")
    public Response<CommentReplyVO> getCommentReplyList(@ApiParam(value = "评论id", required = true) @RequestParam(name = "commentId", required = true) Long commentId,
                                                 @ApiParam(value = "评论人用户名或者姓名", required = false) @RequestParam(name = "name", required = false) String name,
                                                 @ApiParam(value = "状态", required = false) @RequestParam(name = "state", required = false) Integer state) {

        try {
            if (StringUtils.isNotBlank(name)) {
                name = name.trim();
            }
            return Response.ok(commentManageClient.getCommentReplyList(name, state, commentId));
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "评论/回复下架", notes = "评论/回复下架")
    @GetMapping("/putDown")
    public Response<Object> putDown(@ApiParam(value = "评论/回复id", required = true) @RequestParam(name = "id", required = true) Long id,
                             @ApiParam(value = "类型 1:评论 2:回复", required = true) @RequestParam(name = "type", required = true) Integer type) {
        try {
            return Response.ok(commentManageClient.putDown(id, type));
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "评论/回复上架", notes = "评论/回复上架")
    @GetMapping("/release")
    public Response<Object> release(@ApiParam(value = "评论id", required = true) @RequestParam(name = "id", required = true) Long id,
                             @ApiParam(value = "类型 1:评论 2:回复", required = true) @RequestParam(name = "type", required = true) Integer type) {
        try {
            return Response.ok(commentManageClient.release(id, type));
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "评论/回复删除", notes = "评论/回复删除", response = CommentReplyVO.class)
    @GetMapping("/delete")
    public Response<CommentReplyVO> delete(@ApiParam(value = "评论/回复id", required = true) @RequestParam(name = "id", required = true) Long id,
                                    @ApiParam(value = "类型 1:评论 2:回复", required = true) @RequestParam(name = "type", required = true) Integer type) {
        try {
            return Response.ok(commentManageClient.delete(id, type));
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

}
