package com.yizhi.application.language;

import java.util.List;

import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.system.application.system.remote.LanguageClassifyClient;
import com.yizhi.system.application.vo.domain.LanguageClassify;
import com.yizhi.util.application.domain.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;


import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@RestController
@RequestMapping("/manage/languageClassify")
public class LanguageClassifyController {

	private static final Logger logger = LoggerFactory.getLogger(LanguageClassifyController.class);
	
	@Autowired
	private LanguageClassifyClient languageClassifyClient;
	
	@ApiOperation(value = "新增语种",notes = "新增语种")
	@PostMapping("/save")
	public Response<String> save(@RequestBody LanguageClassify languageClassify){
		int i = languageClassifyClient.save(languageClassify);
		switch (i) {
		case 0:
			return Response.fail();
		case 1:
			return Response.ok();
		case 2:
			return Response.fail("语种有重名");
		}
		return Response.ok();
	}
	
	@ApiOperation(value = "修改语种",notes = "修改语种")
	@PostMapping("/update")
	public Response<String> update(@RequestBody LanguageClassify languageClassify){
		int i = languageClassifyClient.update(languageClassify);
		switch (i) {
		case 0:
			return Response.fail();
		case 1:
			return Response.ok();
		case 2:
			return Response.fail(InternationalEnums.LANGUAGECLASSIFYCONTROLLER1.getCode());
		}
		return Response.ok();
	}
	
	@ApiOperation(notes = "删除语种",value = "删除语种")
	@GetMapping("/delete")
	public Response<String> delete(@ApiParam(name = "classifyId",required = true)@RequestParam(name = "classifyId",required = true)Long classifyId){
		int i = languageClassifyClient.delete(classifyId);
		logger.info("删除语种："+classifyId);
		return i==1?Response.ok():Response.fail();
	}
	
	@ApiOperation(value = "语种拖动排序",notes = "语种拖动排序")
	@PostMapping("/sort")
	public Response<String> sort(@RequestBody List<LanguageClassify> list){
		try {
			logger.info("排序的语种列表:"+list.toString());
			int i = languageClassifyClient.sort(list);
			return Response.ok();
		} catch (Exception e) {
			logger.error("语种排序失败",e.getMessage());
			return Response.fail(InternationalEnums.LANGUAGECLASSIFYCONTROLLER2.getCode());
		}
	}
	
	@ApiOperation(value = "管理端语种列表",notes = "管理端语种列表")
	@GetMapping("/list")
	public Response<String> list(@ApiParam(name = "type",required = true)@RequestParam(name = "type",required = true)Integer type){
		List<LanguageClassify> list = languageClassifyClient.list(type);
		return Response.ok(list);
	}
}
