package com.yizhi.application.rangeImport;

import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.live.application.feign.LiveActivityClient;
import com.yizhi.live.application.vo.ScopeAuthorizationVO;
import com.yizhi.system.application.model.AccountRangeImportModel;
import com.yizhi.system.application.model.AccountRangeImportParam;
import com.yizhi.system.application.system.remote.AccountRangeClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @Auther: dingxiaowei
 * @Date: 2018/9/17 16:41
 * @Description:直播可见范围异步导入
 */
@Component
public class LiveRangeImport extends AbstractDefaultTask<String, Map<String, Object>> {

    private static final Logger LOGGER = LoggerFactory.getLogger(LiveRangeImport.class);

    @Autowired
    private AccountRangeClient accountRangeClient;

    @Autowired
    private LiveActivityClient liveActivityClient;

    @Autowired
    private RangeUtil importUtil;

    @Override
    protected String execute(Map<String, Object> map) {

        //从map中取值
        String ossUrl = (String) map.get("ossUrl");
        RequestContext res = (RequestContext) map.get("requestContext");
        Long liveId = (Long) map.get("liveId");
        Long siteId = res.getSiteId();
        Long accountId = res.getAccountId();
        Long companyId = res.getCompanyId();
        Date submitTIme = new Date();
        Long taskId = (Long) map.get("taskId");
        String serialNo = (String) map.get("serialNo");
        String taskName = (String) map.get("taskName");
        TaskContext taskContext = new TaskContext(taskId, serialNo, taskName, accountId, submitTIme, siteId, companyId);
        working(taskContext);
        //将请求值装入param
        AccountRangeImportParam param = new AccountRangeImportParam();
        param.setType(AccountRangeImportParam.Type.LIVE);
        param.setOssUrl(ossUrl);
        param.setRequestContext(res);
        List<AccountRangeImportModel.SuccessAccount> successList = null;
        List<AccountRangeImportModel.ErrorAccount> errorList = null;
        List<Integer> integerList = null;
        //进行入库
        try {
            AccountRangeImportModel accountRangeImportModel = accountRangeClient.doImport(param);
            if (null != accountRangeImportModel) {
                successList = accountRangeImportModel.getSuccessList();
                errorList = accountRangeImportModel.getErrorList();
            }

            errorList = (errorList == null ? new ArrayList<>() : errorList);
            successList = (successList == null ? new ArrayList<>() : successList);
            List<ScopeAuthorizationVO> scopeAuthorizations = new ArrayList<>();


            ScopeAuthorizationVO scopeAuthorization = null;
            if (!CollectionUtils.isEmpty(successList)) {
                for (AccountRangeImportModel.SuccessAccount rangeImportModel : successList) {
                    scopeAuthorization = new ScopeAuthorizationVO();
                    scopeAuthorization.setAccountId(rangeImportModel.getId());
                    scopeAuthorization.setType(2);
                    scopeAuthorization.setName(rangeImportModel.getName());
                    scopeAuthorization.setLiveId(liveId);
                    scopeAuthorization.setSiteId(siteId);
                    scopeAuthorizations.add(scopeAuthorization);
                }
                liveActivityClient.insertScopeAuthorization(scopeAuthorizations);
            }

            importUtil.returnResults(taskContext, successList, errorList, ossUrl);

        } catch (Exception e) {
            e.printStackTrace();
            fail(taskContext, "直播可见范围异步导入过程中出现错误");
            LOGGER.error("直播可见范围异步导入过程中出现错误", e);
        }

        return "ok";
    }
}
