package com.yizhi.application.course.controller;

import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.course.application.feign.CourseStudyHourRankingClient;
import com.yizhi.course.application.vo.CourseStudyDrRankInfoVO;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 15:01 2018/12/19
 * @Modified By
 */
@Api(tags = "课程学习时长排名（前一天的100名")
@RestController
@RequestMapping("/pc/course/ranking")
public class CourseStudyHourRankingController {

    @Autowired
    private CourseStudyHourRankingClient courseStudyHourRankingClient;

    /**
     * 查询当前人的排名和站点排名列表
     * @return
     */
    @ApiOperation(value = "查询当前人的排名和站点排名列表", notes = "自动根据登陆人查询", response = CourseStudyDrRankInfoVO.class)
    @GetMapping("/info")
    public Response<CourseStudyDrRankInfoVO> getListBySiteId(){

        RequestContext rc = ContextHolder.get();
        CourseStudyDrRankInfoVO vo = courseStudyHourRankingClient.getListBySiteId(rc.getSiteId(), rc.getAccountId());

        return Response.ok(vo);
    }

}
