package com.yizhi.application.pc.controller;

import com.baomidou.mybatisplus.plugins.Page;

import com.yizhi.application.pc.vo.MyParamVO;
import com.yizhi.application.pc.vo.MyRespVO;
import com.yizhi.application.tools.PageTools;
import com.yizhi.application.wechat.utils.WechatConstant;
import com.yizhi.album.application.feign.AlbumClient;
import com.yizhi.album.application.vo.ApiListAlbumVo;
import com.yizhi.assignment.application.feign.AssignmentClient;
import com.yizhi.assignment.application.feign.AssignmentStudentClient;
import com.yizhi.assignment.application.vo.AssignmentSelectVo;
import com.yizhi.assignment.application.vo.apivo.ApiAssignmentListResultVO;
import com.yizhi.assignment.application.vo.entity.AssignmentFile;
import com.yizhi.certificate.application.feign.CertificateAppClient;
import com.yizhi.certificate.application.vo.ApiSeachCerticateVo;
import com.yizhi.certificate.application.vo.domain.TrUserCertificateVo;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.course.application.feign.CourseClient;
import com.yizhi.course.application.feign.CoursePcClient;
import com.yizhi.course.application.feign.CourseStudyHourClient;
import com.yizhi.course.application.feign.RecordeClient;
import com.yizhi.course.application.vo.ApiListCourseVo;
import com.yizhi.course.application.vo.MyCourseRecordeVo;
import com.yizhi.course.application.vo.MyDurationVO;
import com.yizhi.exam.application.feign.MyExamClient;
import com.yizhi.exam.application.vo.MyExamParameterVO;
import com.yizhi.exam.application.vo.MyExamVO;
import com.yizhi.exam.application.vo.exam.MyExamPageVO;
import com.yizhi.library.application.feign.StudentCaseClient;
import com.yizhi.library.application.vo.CaseLibraryVO;
import com.yizhi.library.application.vo.StudentCaseStudyVO;
import com.yizhi.research.application.feign.ResearchClient;
import com.yizhi.research.application.vo.api.PageVo;
import com.yizhi.research.application.vo.domain.ResearchVo;
import com.yizhi.site.application.enums.PortalEnum;
import com.yizhi.training.application.feign.TrainingProjectClient;
import com.yizhi.training.application.model.BaseModel;
import com.yizhi.training.application.vo.api.MyPageVO;
import com.yizhi.training.application.vo.api.TrainingProjectListVo;
import com.yizhi.training.application.vo.api.TrainingProjectMyParamVo;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.enums.i18n.Constants;
import com.yizhi.util.application.page.MyPageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;


/**
 * @author lyThinkPad
 */
@Api(tags = "pc端-我的页面接口")
@RestController
@RequestMapping("/pc")
public class PcMyController {

    @Autowired
    private TrainingProjectClient trainingProjectClient;
    @Autowired
    private RecordeClient recordeClient;

    @Autowired
    private AssignmentStudentClient assignmentStudentClient;
    @Autowired
    private AssignmentClient assignmentClient;
    @Autowired
    private MyExamClient myExamClient;

    @Autowired
    private ResearchClient researchClient;

    @Autowired
    private CertificateAppClient certificateAppClient;

    @Autowired
    private CourseClient courseClient;

    @Autowired
    private CoursePcClient coursePcClient;
    @Autowired
    StudentCaseClient studentCaseClient;

    @Autowired
    private CourseStudyHourClient courseStudyHourClient;

    @Autowired
    private AlbumClient albumClient;

    public static final Logger LOGGER = LoggerFactory.getLogger(PcMyController.class);

    @ApiOperation(value = "我的页面所有接口列表", notes = "查询配置里列表", response = MyRespVO.class)
    @GetMapping(value = "/my")
    public Response<MyRespVO> getMyHome(
            @ApiParam(name = "type", value = "类型：1.培训;2.课程;3.作业; 4.考试;5.调研;6.证书;7.收藏;8.我的案例库;9 审核任务；10评分任务；11.学时;12专辑", required = false)
            @RequestParam(value = "type", defaultValue = "1", required = false) Integer type,
            @ApiParam(name = "status", value = "状态：1.未开始(失效);2.进行中;3.已结束", required = false)
            @RequestParam(value = "status", defaultValue = "0", required = false) Integer status,
            @ApiParam(name = "name",value = "模糊查询字段",required = false)
            @RequestParam(name = "name",  required = false) String name,
            @ApiParam(name = "pageNo", value = "当前页", required = false)
            @RequestParam(name = "pageNo", defaultValue = "1", required = false) Integer pageNo,
            @ApiParam(name = "pageSize", value = "每页的条数", required = false)
            @RequestParam(name = "pageSize", required = false) Integer pageSize,
            @ApiParam(name = "startDate", value = "开始时间", required = false) @RequestParam(name = "startDate", required = false) Long startDate,
            @ApiParam(name = "endDate", value = "结束时间", required = false) @RequestParam(name = "endDate", required = false) Long endDate
    ) {
        //获取上下文信息
        RequestContext context = ContextHolder.get();
        if (type.equals(11)){
            pageSize = (pageSize == null ? 10 : pageSize);
        }else {
            pageSize = (pageSize == null ? 20 : pageSize);
        }
        //组装参数
        MyParamVO myParamVO = new MyParamVO();
        myParamVO.setType(type);
        myParamVO.setStatus(status);
        myParamVO.setPageNo(pageNo);
        myParamVO.setPageSize(pageSize);
        myParamVO.setContext(context);

        MyPageInfo<MyRespVO> myPageInfoResp = new MyPageInfo<MyRespVO>();
        switch (type) {
            case 1:
                // 我的培训
                try {
                    myPageInfoResp = getMyTraining(myParamVO);
                } catch (Exception e) {
                    return Response.fail(Constants.TRAINING_MSG_BIZ_ERROR);
                }
                break;
            case 2:
                // 我的课程
                try {
                    myPageInfoResp = getMyCourse(myParamVO, startDate, endDate);
                } catch (Exception e) {
                    return Response.fail(Constants.COURSE_MSG_BIZ_ERROR);
                }
                break;
            case 3:
                // 我的作业
                try {
                    myPageInfoResp = getMyAssignment(myParamVO);
                } catch (Exception e) {
                    return Response.fail(Constants.ASSIGNMENT_MSG_BIZ_ERROR);
                }
                break;
            case 4:
                // 我的考试
                try {
                    myPageInfoResp = getMyExam(myParamVO);
                } catch (Exception e) {
                    return Response.fail(Constants.EXAM_MSG_BIZ_ERROR);
                }
                break;
            case 5:
                // 我的调研
                try {
                    myPageInfoResp = getMyResearch(myParamVO);
                } catch (Exception e) {
                    return Response.fail(Constants.RESEARCH_MSG_BIZ_ERROR);
                }
                break;
            case 6:
                // 我的证书
                try {
                    myPageInfoResp = getMyCertificate(myParamVO);
                } catch (Exception e) {
                    return Response.fail(Constants.CERTIFICATE_MSG_BIZ_ERROR);
                }
                break;
            case 7:
                try {
                    myPageInfoResp = getMyCollect(myParamVO);
                } catch (Exception e) {
                    return Response.fail(Constants.COURSE_MSG_BIZ_ERROR);
                }
            case 8:
                try {
                    myPageInfoResp = getMyCase(myParamVO);
                } catch (Exception e) {
                    return Response.fail(Constants.COURSE_MSG_BIZ_ERROR);
                }
                break;
            case 9:
                try {
                    myPageInfoResp = getMyCaseTask(myParamVO);
                } catch (Exception e) {
                    return Response.fail(Constants.CASELIBRARY_MSG_BIZ_ERROR);
                }
            case 10:
                try {
                    myPageInfoResp = getMyCaseTask(myParamVO);
                } catch (Exception e) {
                    return Response.fail(Constants.CASELIBRARY_MSG_BIZ_ERROR);
                }
                break;

            case 11:
                //我的学时
                try {
                    myPageInfoResp = myDuration(myParamVO);
                } catch (Exception e) {
                    return Response.fail(Constants.COURSE_MSG_BIZ_ERROR);
                }
                break;

            case 12:
                //我的专辑
                try {
                    myPageInfoResp = getMyAlbum(myParamVO);
                } catch (Exception e) {
                    return Response.fail(Constants.ALBUM_MSG_BIZ_ERROR);
                }
                break;
            default:
                break;
        }


        return Response.ok(PageTools.convertPage(myPageInfoResp));


    }

    /**
     * 我的培训
     *
     * @param myParamVO
     * @return
     */
    public MyPageInfo getMyTraining(MyParamVO myParamVO) {
        MyPageInfo<MyRespVO> page = new MyPageInfo<MyRespVO>();
        // 组装请求参数
        TrainingProjectMyParamVo trainingProjectMyParamVo = new TrainingProjectMyParamVo();
        trainingProjectMyParamVo.setNow(new Date());
        trainingProjectMyParamVo.setPageNo(myParamVO.getPageNo());
        trainingProjectMyParamVo.setPageSize(myParamVO.getPageSize());
        trainingProjectMyParamVo.setType(myParamVO.getStatus());
        // 1：未开始，2：进行中，3：已完成，4.已过期"
        BaseModel<TrainingProjectMyParamVo> model = new BaseModel<>();
        model.setContext(myParamVO.getContext());
        model.setDate(new Date());
        model.setObj(trainingProjectMyParamVo);
        Page<TrainingProjectListVo> voPage = trainingProjectClient.apiMyPageList(model);
        //记录条数
        Integer type = model.getObj().getType();


        MyPageVO myPageVO = trainingProjectClient.apiMyPageListCount(model);
        page.setUnStartRecords(myPageVO.getUnStartRecords());
        page.setProcessRecords(myPageVO.getProcessRecords());
        page.setFinishRecords(myPageVO.getFinishRecords());

        if (type == 1) {
            // 总页数
            Integer unStartRecords = myPageVO.getUnStartRecords();
            if (unStartRecords != 0) {
                page.setPageTotal(unStartRecords / myParamVO.getPageSize() + 1);
            }

        } else if (type == 2) {
            // 总页数
            Integer processRecords = myPageVO.getProcessRecords();
            if (processRecords != 0) {
                page.setPageTotal(processRecords / myParamVO.getPageSize() + 1);
            }
        } else {
            // 总页数
            Integer finishRecords = myPageVO.getFinishRecords();
            if (finishRecords != 0) {
                page.setPageTotal(finishRecords / myParamVO.getPageSize() + 1);
            }
        }


        // 当前页
        page.setPageNo(myParamVO.getPageNo());

        // 每页记录数
        page.setPageSize(myParamVO.getPageSize());

        List<MyRespVO> trainingProjectListVos = new ArrayList<MyRespVO>();
        MyRespVO myRespVO = null;

        for (TrainingProjectListVo tVo : voPage.getRecords()) {
            myRespVO = new MyRespVO();
            myRespVO.setId(tVo.getId());
            myRespVO.setName(tVo.getName());
            ArrayList<String> images = new ArrayList<String>();
            images.add(tVo.getLogoImg());
            myRespVO.setImages(images);
            myRespVO.setStartTime(tVo.getStartTime());
            myRespVO.setEndTime(tVo.getEndTime());
            myRespVO.setTimes(tVo.getJoinNumber());

            trainingProjectListVos.add(myRespVO);
        }
        page.setRecords(trainingProjectListVos);

        return page;

    }

    /**
     * 课程
     *
     * @param myParamVO
     * @return
     */
    public MyPageInfo getMyCourse(MyParamVO myParamVO, Long startDate, Long endDate) {

        MyPageInfo<MyRespVO> page = new MyPageInfo<MyRespVO>();
        // 0 进行中 1 为已完成 ,不传则查询所有
        Integer type = myParamVO.getStatus();
        if (type.equals(2)) {
            type = 0;
        } else if (type.equals(3)) {
            type = 1;
        } else {
            type = null;
        }

        RequestContext rt = ContextHolder.get();

        Page<MyCourseRecordeVo> myCourseRecordVoPage = coursePcClient.getMyCourseStudyList(
                rt.getSiteId(), rt.getAccountId(), null, type, myParamVO.getPageNo(), myParamVO.getPageSize(), startDate, endDate);

        // 统计我的学习数量情况
        List<String> studyCountNum = myCourseRecordVoPage.getDescs();
        page.setFinishRecords(Integer.valueOf(studyCountNum.get(1)));
        page.setProcessRecords(Integer.valueOf(studyCountNum.get(2)));

        /*Page<MyCourseRecordeVo> myCourseRecordVoPage =
                recordeClient.getMyCourseRecordeList(null, myParamVO.getContext().getAccountId(),
                        type, myParamVO.getPageNo(), myParamVO.getPageSize());*/

        List<MyRespVO> list = new ArrayList<MyRespVO>();
        MyRespVO myRespVO = null;
        if (CollectionUtils.isNotEmpty(myCourseRecordVoPage.getRecords())) {
            for (MyCourseRecordeVo myCourseRecordeVo : myCourseRecordVoPage.getRecords()) {
                myRespVO = new MyRespVO();
                myRespVO.setId(myCourseRecordeVo.getId());
                myRespVO.setName(myCourseRecordeVo.getName());
                myRespVO.setImages(Arrays.asList(myCourseRecordeVo.getImage()));
                myRespVO.setValid(myCourseRecordeVo.getValid());
                myRespVO.setPercent(myCourseRecordeVo.getPercent());
                myRespVO.setLevel(myCourseRecordeVo.getLevel());
                myRespVO.setDuration(myCourseRecordeVo.getDuration());
                list.add(myRespVO);
            }
        }

        // 记录条数
/*        if (type==0){
            page.setProcessRecords(myCourseRecordVoPage.getTotal());
            page.setFinishRecords(recordeClient.getMyCourseRecordeCount(myParamVO.getContext().getAccountId(),1));
        }
        if (type==1){
            page.setFinishRecords(myCourseRecordVoPage.getTotal());
            page.setProcessRecords(recordeClient.getMyCourseRecordeCount(myParamVO.getContext().getAccountId(),0));
        }*/

        // 获取作业的总条数
//        Integer assignmentCount=assignmentStudentClient.getAssignmentNumByAccountId(myParamVO.getContext().getRelationIds()
//                , myParamVO.getContext().getSiteId(),myParamVO.getContext().getAccountId());


        // 总页数
        page.setPageTotal(myCourseRecordVoPage.getPages());

        // 当前页
        page.setPageNo(myParamVO.getPageNo());

        // 每页记录数
        page.setPageSize(myParamVO.getPageSize());

        // 记录条数
        page.setRecords(list);

        return page;
    }

    /**
     * 我的作业
     *
     * @param myParamVO
     * @return
     */
    public MyPageInfo getMyAssignment(MyParamVO myParamVO) {

        MyPageInfo<MyRespVO> page = new MyPageInfo<MyRespVO>();
        // 1,进行中，2：已结束
        Integer type = myParamVO.getStatus();
        if (type.equals(2)) {
            type = 1;
        }
        if (type.equals(3)) {
            type = 2;
        }

        Page<ApiAssignmentListResultVO> myAssignmentList = new Page<ApiAssignmentListResultVO>();
        myAssignmentList = assignmentStudentClient.list(type, myParamVO.getPageNo(), myParamVO.getPageSize(), myParamVO.getContext().getAccountId(),
                myParamVO.getContext().getRelationIds(), myParamVO.getContext().getCompanyId(), myParamVO.getContext().getSiteId());
        LOGGER.info("assignment total:" + myAssignmentList.getTotal());

        List<MyRespVO> list = new ArrayList<MyRespVO>();
        MyRespVO myRespVO = null;
        for (ApiAssignmentListResultVO myAssignment : myAssignmentList.getRecords()) {
            myRespVO = new MyRespVO();
            myRespVO.setId(myAssignment.getId());
            myRespVO.setName(myAssignment.getAssignmentName());
            ArrayList<String> images = new ArrayList<String>();
            AssignmentSelectVo assignmentSelectVo = assignmentClient.query(myAssignment.getId());
            List<AssignmentFile> assignmentFiles = assignmentSelectVo.getAssignmentFiles();
            for (AssignmentFile asg : assignmentFiles) {
                images.add(asg.getFileUrl());
            }
            myRespVO.setImages(images);
            myRespVO.setTimes(myAssignment.getCount());
            myRespVO.setPassScore(myAssignment.getPassScore());
            myRespVO.setEndTime(myAssignment.getFinishTime());
            myRespVO.setStatus(myAssignment.getStatus());
            myRespVO.setDetail(myAssignment.getDetail());
            myRespVO.setHandle(myAssignment.getHandle());
            list.add(myRespVO);
        }

        // 获取作业的总条数
        Integer assignmentCount = assignmentStudentClient.getAssignmentNumByAccountId(myParamVO.getContext().getRelationIds()
                , myParamVO.getContext().getSiteId(), myParamVO.getContext().getAccountId());

        LOGGER.info("TTL ttl：" + assignmentCount);
        // 总页数
        Integer pageTotal = 0;
        //记录条数
        if (type == 1) {
            page.setProcessRecords(myAssignmentList.getTotal());
            page.setFinishRecords(assignmentCount - myAssignmentList.getTotal());
            // 总页数
            pageTotal = myAssignmentList.getTotal() / myParamVO.getPageSize() + 1;

        } else if (type == 2) {
            page.setFinishRecords(myAssignmentList.getTotal());
            page.setProcessRecords(assignmentCount - myAssignmentList.getTotal());
            // 总页数
            pageTotal = myAssignmentList.getTotal() / myParamVO.getPageSize() + 1;
        }

        page.setPageTotal(pageTotal);

        // 当前页
        page.setPageNo(myParamVO.getPageNo());

        // 每页记录数
        page.setPageSize(myParamVO.getPageSize());

        //记录
        page.setRecords(list);

        return page;
    }

    /**
     * 我的考试
     *
     * @param myParamVO
     * @return
     */
    public MyPageInfo getMyExam(MyParamVO myParamVO) {

        Integer status = myParamVO.getStatus() - 1;

        MyPageInfo<MyRespVO> page = new MyPageInfo<MyRespVO>();

        MyExamParameterVO myExamParameterVO = new MyExamParameterVO();
        myExamParameterVO.setPageNo(myParamVO.getPageNo());
        myExamParameterVO.setPageSize(myParamVO.getPageSize());
        myExamParameterVO.setState(status);
        LOGGER.info("参数：" + myExamParameterVO);

        MyExamPageVO myPcExamList = null;
        try {
            myPcExamList = myExamClient.getMyPcExamList(myExamParameterVO);

            LOGGER.info("exam 返回结果{}", myPcExamList.getExamVOS());
        } catch (Exception e) {
            LOGGER.info("exam 返回结果{}", e);
        }

        List<MyRespVO> list = new ArrayList<MyRespVO>();
        MyRespVO myRespVO = null;
        if (CollectionUtils.isNotEmpty(myPcExamList.getExamVOS())) {
            for (MyExamVO myExamVO : myPcExamList.getExamVOS()) {
                myRespVO = new MyRespVO();
                myRespVO.setId(myExamVO.getId());
                myRespVO.setName(myExamVO.getName());
                myRespVO.setStartTime(myExamVO.getStartTime());
                myRespVO.setEndTime(myExamVO.getEndTime());
                myRespVO.setTimes(myExamVO.getMaxNum());
                myRespVO.setStatus(myExamVO.getIsQualified() == null ? null : Integer.valueOf(myExamVO.getIsQualified()));
                myRespVO.setHandle(myExamVO.getHandle());
                myRespVO.setCompletionTimes(myExamVO.getExamNum());
                if (myExamVO.getQualifiedScore() != null) {
                    myRespVO.setPassScore((myExamVO.getQualifiedScore()).intValue());
                }
                myRespVO.setAnswerId(myExamVO.getAnswerId());
                list.add(myRespVO);
            }
        }
        page.setRecords(list);
        page.setProcessRecords(myPcExamList.getInProgressCount());
        page.setUnStartRecords(myPcExamList.getNotStartCount());
        page.setFinishRecords(myPcExamList.getCompletedCount());
        // 当前页
        page.setPageNo(myParamVO.getPageNo());

        // 每页记录数
        page.setPageSize(myParamVO.getPageSize());
        return page;
    }

    /**
     * 我的调研
     *
     * @param myParamVO
     * @return
     */
    public MyPageInfo getMyResearch(MyParamVO myParamVO) {

        MyPageInfo<MyRespVO> page = new MyPageInfo<MyRespVO>();
        PageVo pageVo = new PageVo();

        pageVo.setAccountId(ContextHolder.get().getAccountId());
        System.out.println("accountId:" + ContextHolder.get().getAccountId());
        pageVo.setDate(new Date());
        pageVo.setPageNo(myParamVO.getPageNo());
        pageVo.setPageSize(myParamVO.getPageSize());

        pageVo.setState(2);
        com.yizhi.research.application.vo.BaseModel<PageVo> model = new com.yizhi.research.application.vo.BaseModel<PageVo>();
        model.setDate(new Date());
        model.setObj(pageVo);
        model.setContext(ContextHolder.get());
        Page<ResearchVo> researchPage = researchClient.apiListPage(model);

        List<MyRespVO> list = new ArrayList<MyRespVO>(WechatConstant.INITSIZE);
        MyRespVO myRespVO = null;
        if (CollectionUtils.isNotEmpty(researchPage.getRecords())) {
            for (ResearchVo research : researchPage.getRecords()) {
                myRespVO = new MyRespVO();
                myRespVO.setId(research.getId());
                myRespVO.setName(research.getName());
                myRespVO.setStartTime(research.getStartTime());
                myRespVO.setEndTime(research.getEndTime());
                list.add(myRespVO);
            }
        }

        //记录条数
        page.setProcessRecords(researchPage.getTotal());
        // 总页数
        page.setPageTotal(researchPage.getPages());

        // 当前页
        page.setPageNo(myParamVO.getPageNo());

        // 每页记录数
        page.setPageSize(myParamVO.getPageSize());
        // 记录
        page.setRecords(list);
        return page;

    }

    /**
     * 我的证书
     *
     * @param myParamVO
     * @return
     */
    public MyPageInfo getMyCertificate(MyParamVO myParamVO) {

        MyPageInfo<MyRespVO> page = new MyPageInfo<MyRespVO>();

        ApiSeachCerticateVo apiSeachCerticateVo = new ApiSeachCerticateVo();
        //状态：1.未开始;2.进行中;3.已结束
        String validityType = "1";
//        1为有效，0为失效"
        if (myParamVO.getStatus().equals(WechatConstant.ONE)) {
            validityType = "0";
        }
        apiSeachCerticateVo.setValidityType(validityType);
        apiSeachCerticateVo.setPageNo(myParamVO.getPageNo());
        apiSeachCerticateVo.setPageSize(myParamVO.getPageSize());
        RequestContext requestContext = myParamVO.getContext();
        apiSeachCerticateVo.setAccountId(requestContext.getAccountId());
        apiSeachCerticateVo.setCompanyId(requestContext.getCompanyId());
        apiSeachCerticateVo.setSiteId(requestContext.getSiteId());
        Page<TrUserCertificateVo> certificatePage = certificateAppClient.list(apiSeachCerticateVo);
        LOGGER.info("证书接口返回" + certificatePage.getTotal());

        List<MyRespVO> list = new ArrayList<MyRespVO>(WechatConstant.INITSIZE);
        MyRespVO myRespVO = null;
        if (CollectionUtils.isNotEmpty(certificatePage.getRecords())) {
            for (TrUserCertificateVo certificate : certificatePage.getRecords()) {
                myRespVO = new MyRespVO();
                myRespVO.setId(certificate.getId());
                myRespVO.setName(certificate.getCertificateTitle());
                myRespVO.setStartTime(certificate.getCreateTime());
                List<String> images = new ArrayList<>(WechatConstant.INITSIZE);
                images.add(certificate.getCertificateLogourl());
                myRespVO.setImages(images);
                myRespVO.setEndTime(certificate.getEndTime());
                if (null != certificate.getTrainingProjectName()) {
                    myRespVO.setSource(certificate.getTrainingProjectName());
                } else {
                    myRespVO.setSource(certificate.getTpPlanName());
                }
                list.add(myRespVO);
            }
        }
        LOGGER.info("封装后证书接口返回{}" + list);

        // 获取证书总数
        Integer certificateCount = certificateAppClient.getCertificateCount(requestContext.getAccountId(), requestContext.getCompanyId(), requestContext.getSiteId());

        if ("1".equals(validityType)) {
            //记录条数
            page.setProcessRecords(certificatePage.getTotal());
            page.setFinishRecords(certificateCount - certificatePage.getTotal());
        } else {
            page.setFinishRecords(certificatePage.getTotal());
            page.setProcessRecords(certificateCount - certificatePage.getTotal());
        }


        // 总页数
        page.setPageTotal(certificatePage.getPages());

        // 当前页
        page.setPageNo(myParamVO.getPageNo());

        // 每页记录数
        page.setPageSize(myParamVO.getPageSize());
        // 记录
        page.setRecords(list);

        return page;
    }

    /**
     * 我的收藏
     *
     * @param myParamVO
     * @return
     */
    public MyPageInfo getMyCollect(MyParamVO myParamVO) {

        MyPageInfo<MyRespVO> page = new MyPageInfo<MyRespVO>();

        RequestContext context = myParamVO.getContext();

        Page<ApiListCourseVo> collectPage =
                courseClient.getPCMyFavoriteList(context.getAccountId(), null, context.getCompanyId(),
                        context.getSiteId(), myParamVO.getPageNo(), myParamVO.getPageSize());

        List<MyRespVO> list = new ArrayList<MyRespVO>(WechatConstant.INITSIZE);
        MyRespVO myRespVO = null;
        if (CollectionUtils.isNotEmpty(collectPage.getRecords())) {
            for (ApiListCourseVo apiListCourseVo : collectPage.getRecords()) {
                myRespVO = new MyRespVO();

                myRespVO.setName(apiListCourseVo.getName());
                myRespVO.setId(apiListCourseVo.getId());
                List<String> images = new ArrayList<String>(WechatConstant.INITSIZE);
                images.add(apiListCourseVo.getImage());
                myRespVO.setImages(images);
                myRespVO.setValid(apiListCourseVo.getValid());
                myRespVO.setLevel(apiListCourseVo.getLevel());
                list.add(myRespVO);
            }
        }

        //记录条数
        page.setProcessRecords(collectPage.getTotal());
        // 总页数
        page.setPageTotal(collectPage.getPages());

        // 当前页
        page.setPageNo(myParamVO.getPageNo());

        // 每页记录数
        page.setPageSize(myParamVO.getPageSize());
        // 记录
        page.setRecords(list);


        return page;
    }

    /**
     * 我的学时统计
     * @return
     */
    public MyPageInfo myDuration(MyParamVO myParamVO){

        MyPageInfo<MyDurationVO> page = new MyPageInfo<MyDurationVO>();
        RequestContext context = myParamVO.getContext();
        Page<MyDurationVO> voPage = courseStudyHourClient.queryDurationByAccountId(context.getAccountId(), context.getSiteId(), myParamVO.getPageNo(), myParamVO.getPageSize());


        //记录条数
        page.setProcessRecords(voPage.getTotal());
        // 总页数
        page.setPageTotal(voPage.getPages());

        // 当前页
        page.setPageNo(myParamVO.getPageNo());

        // 每页记录数
        page.setPageSize(myParamVO.getPageSize());

        // 记录
        page.setRecords(voPage.getRecords());

        return page;
    }

    /**
     * 我的的案例库
     *
     * @param myParamVO
     * @return
     */
    public MyPageInfo getMyCase(MyParamVO myParamVO) {
        MyPageInfo<MyRespVO> page = new MyPageInfo<MyRespVO>();

        RequestContext context = myParamVO.getContext();
        Page<CaseLibraryVO> caseLibraryVOPage = studentCaseClient.myCaseLibraryList(myParamVO.getPageNo(), myParamVO.getPageSize());


        List<MyRespVO> list = new ArrayList<MyRespVO>(WechatConstant.INITSIZE);
        MyRespVO myRespVO = null;
        if (CollectionUtils.isNotEmpty(caseLibraryVOPage.getRecords())) {
            for (CaseLibraryVO caseLibraryVO : caseLibraryVOPage.getRecords()) {
                myRespVO = new MyRespVO();

                myRespVO.setName(caseLibraryVO.getName());
                myRespVO.setId(caseLibraryVO.getId());
                myRespVO.setEndTime(caseLibraryVO.getEndTime());
                List<String> images = new ArrayList<String>(WechatConstant.INITSIZE);
                images.add(caseLibraryVO.getLogoUrl());
                myRespVO.setImages(images);
                myRespVO.setProcessCount(caseLibraryVO.getInProgressNum());
                myRespVO.setCompletionTimes(caseLibraryVO.getFinishNum());
                myRespVO.setHandle(caseLibraryVO.getIsMustSubmit());
                //必须提交 已过期
                //0:不必须提交 1:必须提交"
                LOGGER.info("是否提交或过期:"+caseLibraryVO.getIsMustSubmit());
                myRespVO.setTimes(caseLibraryVO.getIsMustSubmit()!=null ?caseLibraryVO.getIsMustSubmit(): PortalEnum.ZERO.ordinal());
                list.add(myRespVO);
            }
        }

        //记录条数
        page.setProcessRecords(caseLibraryVOPage.getTotal());
        // 总页数
        page.setPageTotal(caseLibraryVOPage.getPages());

        // 当前页
        page.setPageNo(myParamVO.getPageNo());

        // 每页记录数
        page.setPageSize(myParamVO.getPageSize());
        // 记录
        page.setRecords(list);

        return page;
    }

    /**
     *
     *  type 1审核任务 2评分任务
     * @param myParamVO
     * @return
     */
    public MyPageInfo getMyCaseTask(MyParamVO myParamVO) {
        MyPageInfo<MyRespVO> page = new MyPageInfo<MyRespVO>();
        Integer type = myParamVO.getType();
        type = type==9?1:2;
        LOGGER.info("参数type："+type);
        RequestContext context = myParamVO.getContext();
        Page<StudentCaseStudyVO> auditList = studentCaseClient.getAuditList(type, myParamVO.getName(), myParamVO.getPageNo(), myParamVO.getPageSize());


        List<MyRespVO> list = new ArrayList<MyRespVO>(WechatConstant.INITSIZE);
        MyRespVO myRespVO = null;
        if (CollectionUtils.isNotEmpty(auditList.getRecords())) {
            for (StudentCaseStudyVO studentCaseStudyVO : auditList.getRecords()) {
                myRespVO = new MyRespVO();

                myRespVO.setName(studentCaseStudyVO.getTitle());
                myRespVO.setAuthor(studentCaseStudyVO.getAuthorName());
                myRespVO.setId(studentCaseStudyVO.getStudentCaseId());
                myRespVO.setStartTime(studentCaseStudyVO.getSubmitTime());
                myRespVO.setEndTime(studentCaseStudyVO.getAuditTime());
                list.add(myRespVO);
            }
        }

        //记录条数
        page.setProcessRecords(auditList.getTotal());
        // 总页数
        page.setPageTotal(auditList.getPages());

        // 当前页
        page.setPageNo(myParamVO.getPageNo());

        // 每页记录数
        page.setPageSize(myParamVO.getPageSize());
        // 记录
        page.setRecords(list);

        return page;
    }


    /**
     * 专辑
     *
     * @param myParamVO
     * @return
     */
    public MyPageInfo getMyAlbum(MyParamVO myParamVO) {
        MyPageInfo<MyRespVO> page = new MyPageInfo<MyRespVO>();
        RequestContext rt = ContextHolder.get();
        Page<ApiListAlbumVo> myAlbumList = albumClient.getMyAlbumList(rt.getSiteId(), rt.getAccountId(), myParamVO.getPageNo(), myParamVO.getPageSize());
        List<MyRespVO> list = new ArrayList<MyRespVO>();
        MyRespVO myRespVO = null;
        if (CollectionUtils.isNotEmpty(myAlbumList.getRecords())) {
            for (ApiListAlbumVo myAlbum : myAlbumList.getRecords()) {
                myRespVO = new MyRespVO();
                myRespVO.setId(myAlbum.getId());
                myRespVO.setName(myAlbum.getName());
                myRespVO.setImages(Arrays.asList(myAlbum.getImage()));
                myRespVO.setPercent(myAlbum.getPercent());
                myRespVO.setOvered(myAlbum.getOvered());
                myRespVO.setUnLockTime(myAlbum.getUnLockTime());
                list.add(myRespVO);
            }
        }
        // 总页数
        page.setPageTotal(myAlbumList.getPages());

        // 当前页
        page.setPageNo(myParamVO.getPageNo());

        // 每页记录数
        page.setPageSize(myParamVO.getPageSize());

        // 记录数
        page.setRecords(list);

     // 记录条数
        page.setProcessRecords(myAlbumList.getTotal());

        return page;
    }
}
