package com.yizhi.application.point.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.point.application.feign.PointApiFeignClients;
import com.yizhi.point.application.feign.PointProductFeignClients;
import com.yizhi.point.application.vo.PointDetailListVO;
import com.yizhi.point.application.vo.PointSearchParamVO;
import com.yizhi.point.application.vo.domain.PointProductVo;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 积分商城
 */

@Api(tags = "积分商城")
@RestController
@RequestMapping("/api/point")
public class PointController {

    private static final Logger LOG = LoggerFactory.getLogger(PointController.class);

    @Autowired
    PointProductFeignClients pointProductFeignClients;
    @Autowired
    PointApiFeignClients pointApiFeignClients;

    @ApiOperation(value = "积分明细", notes = "积分明细")
    @PostMapping("/list")
    public Response<List<PointDetailListVO>> list(@RequestBody PointSearchParamVO searchParamVO) {
        RequestContext requestContext = ContextHolder.get();
        if (null == requestContext) {
            Response.fail();
        }
        Long accountId = requestContext.getCompanyId();
        return Response.ok(pointApiFeignClients.list(accountId, searchParamVO.getPageNo(), searchParamVO.getPageSize()));
    }

    @ApiOperation(value = "积分兑换商品列表", notes = "积分兑换商品列表")
    @PostMapping("/productList")
    public Response<Object> productList(@RequestBody PointSearchParamVO searchParamVO) {
        return Response.ok(pointApiFeignClients.productList(searchParamVO.getPageNo(), searchParamVO.getPageSize()));
    }

    @ApiOperation(value = "积分兑换", notes = "积分兑换")
    @PostMapping("/exchange")
    public Response<Object> exchange(@RequestBody JSONObject json) {
        String productIds = json.getString("productIds");
        RequestContext requestContext = ContextHolder.get();
        if (null == requestContext) {
            Response.fail();
        }
        Long companyId = requestContext.getCompanyId();
        Long siteId = requestContext.getSiteId();
        Long orgId = requestContext.getOrgId();
        Long accountId = requestContext.getAccountId();
        String accountName = requestContext.getAccountName();
        boolean ret = pointApiFeignClients.exchange(companyId, orgId, siteId, accountId, accountName, productIds);
        if(ret) {
            return Response.ok();
        } else {
            return Response.fail();
        }
    }

}
