package com.yizhi.application.point.controller;

import java.util.Map;

import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.point.application.feign.PointDetailsFeignClients;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;



import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * 我的积分
 *
 * @author mei
 * @Date: 2018/3/17 20:30
 */

@Api(tags = "我的积分 学员端")
@RestController
@RequestMapping("/api/point/detail")
public class PointDetailsController {

    private static final Logger LOG = LoggerFactory.getLogger(PointDetailsController.class);

    @Autowired
    PointDetailsFeignClients pointDetailsFeignClients;

    @ApiOperation(value = "我的积分明细 学员端", notes = "我的积分明细 学员端")
    @GetMapping("/pointList")
    public Response<Object> pointList(
            @ApiParam(value = "年份", required = false) @RequestParam(name = "year", required = false, defaultValue = "") String year,
            @ApiParam(value = "type", required = false) @RequestParam(name = "type", required = false, defaultValue = "") String type,
            @ApiParam(value = "每页条数，默认10", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
            @ApiParam(value = "当前页数默认为1", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo) {
        RequestContext requestContext = ContextHolder.get();
        if (null == requestContext) {
            Response.fail();
        }
        Long accountId = requestContext.getAccountId();
        Long companyId = requestContext.getCompanyId();
        Long orgId = requestContext.getOrgId();
        Long siteId = requestContext.getSiteId();
        Map<String, Object> map = pointDetailsFeignClients.pointList(year,type, accountId, pageNo, pageSize, companyId, siteId, orgId);
        if (map == null) {
            Response.fail(ReturnCode.RESOURCE_NOT_FOUND);
        }
        Map<String, Object> listMap = (Map<String, Object>) map.get("listMap");
        Map<String, Integer> pageMap = (Map<String, Integer>) map.get("page");
        return Response.ok(listMap, pageMap);
    }

    @ApiOperation(value = "我的积分 学员端", notes = "我的积分 学员端")
    @GetMapping("/countList")
    public Response<Integer> queryPiont() {
        RequestContext requestContext = ContextHolder.get();
        if (null == requestContext) {
            Response.fail();
        }
        Long accountId = requestContext.getAccountId();
        Long companyId = requestContext.getCompanyId();
        Long orgId = requestContext.getOrgId();
        Long siteId = requestContext.getSiteId();
        return Response.ok(pointDetailsFeignClients.queryPiont(accountId, companyId, siteId, orgId));

    }

}
