package com.yizhi.application.project.controller;

import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.site.application.feign.InformationStudentFeignClients;
import com.yizhi.site.application.feign.api.EventTrackApiClients;
import com.yizhi.site.application.vo.site.IdOneVO;
import com.yizhi.site.application.vo.site.InformationViewVO;
import com.yizhi.training.application.feign.TpCommentClient;
import com.yizhi.training.application.feign.TpCommentThumbsUpClient;
import com.yizhi.training.application.vo.domain.TpCommentThumbsUpVo;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.enums.i18n.Constants;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 培训项目 - 评论 前端控制器
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-27
 */
@Api(tags = "培训项目--评论点赞接口")
@RestController
@RequestMapping("/api/tpCommentThumbsUp")
public class TpCommentThumbsUpApiController {

    @Autowired
    TpCommentThumbsUpClient tpCommentThumbsUpClient;
    @Autowired
    TpCommentClient tpCommentClient;
    @Autowired
    private EventTrackApiClients eventTrackApiClients;
    @Autowired
    InformationStudentFeignClients informationStudentFeignClients;

    private static final Logger LOGGER = LoggerFactory.getLogger(TpCommentThumbsUpApiController.class);

    @PostMapping("/save")
    @ApiOperation(value = "学员端对项目评论点赞", notes = "返回操作是否成功")
    public Response save(
            @RequestBody TpCommentThumbsUpVo tpCommentThumbsUp
//            @ApiParam(value = "项目评论id", required = true) @RequestParam("commmentId") Long commmentId
    ) {

        RequestContext requestContext = ContextHolder.get();
        tpCommentThumbsUp.setAccountId(requestContext.getAccountId());
        Boolean f = tpCommentThumbsUpClient.save(tpCommentThumbsUp);
        if (f) {
            LOGGER.info("点赞成功");
            RequestContext context = ContextHolder.get();
            IdOneVO idOneVO =new IdOneVO();
            idOneVO.setId(tpCommentThumbsUp.getTrainingProjectId());
            idOneVO.setContext(context);
            InformationViewVO viewVO = informationStudentFeignClients.getInformation(idOneVO);
            // if(request.getHeader("Cookie")!=null&&Objects.equals(redisCache.get(request.getHeader("Cookie").replace("JSESSIONID=","")),"2")){
            eventTrackApiClients.addEvent("event_admire_"+viewVO.getTypeOne(),tpCommentThumbsUp.getTrainingProjectId());
            //  }
            return Response.ok("点赞成功");
        } else {
            LOGGER.error("点赞失败");
            return Response.fail("点赞失败");
        }
    }


    @PostMapping("/delete")
    @ApiOperation(value = "学员端对项目评论取消点赞", notes = "返回操作是否成功")
    public Response delete(
            @RequestBody TpCommentThumbsUpVo tpCommentThumbsUp
//            @ApiParam(value = "项目评论id",required = true)@RequestParam("commmentId")Long commmentId
    ){
        RequestContext requestContext = ContextHolder.get();
//        TpCommentThumbsUp tpCommentThumbsUp = new TpCommentThumbsUp();
//        tpCommentThumbsUp.setTpCommentId(commmentId);
        tpCommentThumbsUp.setAccountId(requestContext.getAccountId());
        Boolean f = tpCommentThumbsUpClient.delete(tpCommentThumbsUp);
        if (f) {
            LOGGER.info("取消点赞成功");
            return Response.ok("取消点赞成功");
        } else {
            LOGGER.error("取消点赞失败");
            return Response.fail("取消点赞失败");
        }
    }

    /**
     * PC端点赞
     *
     * @param commentThumbsUp
     * @return
     */
    @PostMapping("/pc/save")
    @ApiOperation(value = "PC端给评论点赞",response =TpCommentThumbsUpVo.class )
    Response saveTpCommentThumbsUp(@ApiParam(value = "tpCommentId-评论ID") @RequestBody TpCommentThumbsUpVo commentThumbsUp) {

        RequestContext requestContext = ContextHolder.get();
        commentThumbsUp.setAccountId(requestContext.getAccountId());
        Boolean flag = tpCommentThumbsUpClient.save(commentThumbsUp);
        if (!flag) {
            return Response.fail(Constants.MSG_COMMENT_THUMBSUP_FAIL.getCode().toString(),
                    Constants.MSG_COMMENT_THUMBSUP_FAIL.getName());
        }
        commentThumbsUp.setHasThumbsUp(true);
        return Response.ok(commentThumbsUp);

    }

    /**
     * PC端取消赞
     *
     * @param tpCommentThumbsUp
     * @return
     */
    @PostMapping("/pc/delete")
    @ApiOperation(value = "PC端对项目评论取消点赞",response =TpCommentThumbsUpVo.class )
    public Response deleteTpCommentThumbsUp(@ApiParam(value = "tpCommentId-评论ID")
                                            @RequestBody TpCommentThumbsUpVo tpCommentThumbsUp
    ) {
        RequestContext requestContext = ContextHolder.get();
        tpCommentThumbsUp.setAccountId(requestContext.getAccountId());
        Boolean f = tpCommentThumbsUpClient.delete(tpCommentThumbsUp);
        if (f) {
            tpCommentThumbsUp.setHasThumbsUp(false);
            return Response.ok(tpCommentThumbsUp);
        } else {
            return Response.fail(Constants.MSG_CANCEL_THUMBSUP_FAIL.getCode().toString(),
                    Constants.MSG_CANCEL_THUMBSUP_FAIL.getName());
        }
    }

    /**
     * pc端对项目评论进行点赞统计
     *
     * @param tpCommentId
     * @return
     */
    @GetMapping("/pc/count")
    @ApiOperation(value = "pc端对项目评论进行点赞统计")
    public Response countTpCommentThumbsUp(@ApiParam(value = "tpCommentId-评论ID")
                                           @RequestParam(value = "tpCommentId")
                                                   Long tpCommentId) {
        Integer i = tpCommentThumbsUpClient.countThumbsUp(tpCommentId);
        return Response.ok(i);
    }

}

