package com.yizhi.application.protal.controller;

import java.util.ArrayList;
import java.util.List;

import com.yizhi.application.protal.constant.BannerNameEnum;
import com.yizhi.application.protal.constant.TerminalEnum;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.research.application.feign.ResearchClient;
import com.yizhi.research.application.vo.domain.ResearchVo;
import com.yizhi.site.application.feign.BannerManageFeignClients;
import com.yizhi.site.application.vo.site.AllHomeBannerImageVO;
import com.yizhi.site.application.vo.site.ImageListVO;
import com.yizhi.training.application.feign.TrainingProjectClient;
import com.yizhi.training.application.vo.domain.TrainingProjectVo;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

@Api(tags = "轮播学员端管理")
@RestController
@RequestMapping("/api/banner")
public class BannerApiController {
	
	private static final Logger LOGGER = LoggerFactory.getLogger(BannerApiController.class);
	
	@Autowired
	BannerManageFeignClients bannerManageFeignClients;
	
	@Autowired
	TrainingProjectClient trainingProjectClient;
	
	@Autowired
	ResearchClient researchClient;
	
	/**
	 * 所有首页 轮播图
	 */
	@ApiOperation(value = "轮播学员端管理", notes = "轮播学员端管理", response = ImageListVO.class)
	@PostMapping(value="/home/image/list")
	@ApiImplicitParams({
		@ApiImplicitParam(name="bannerName" , value="轮播图所属栏目, MARKET:营销, TRAIN:培训, HOMEPAGE:首页, COURSE:课程, NEWS:新闻资讯，ALBUM:专辑;TRAIN_EXAM:培训测验;RESEARCH:问卷调查", dataType="Long"),
		@ApiImplicitParam(name="terminalName" , value="终端名称, PC端：PC; APP： MOBILE; 微信: WECHAT", dataType="Long")
	})
	public Response<List<ImageListVO>> listAllHomeBannerImage(@RequestBody AllHomeBannerImageVO vo){
		if(vo.getBannerName() == null || vo.getTerminalName() == null){
			return Response.fail("参数不能为空");
		}
		String bannerName = BannerNameEnum.getBannerKey(vo.getBannerName());
		String terminalName = vo.getTerminalName();
//		if(vo.getTerminalName().equals("WECHAT")){
//			terminalName = "MOBILE";
//		}
		terminalName = TerminalEnum.getTerminalKey(terminalName);
		if(StringUtils.isBlank(bannerName)){
			return Response.fail("栏目名称错误");
		}
		if(StringUtils.isBlank(terminalName)){
			return Response.fail("终端名称错误");
		}
		RequestContext context = ContextHolder.get();
		vo.setCompanyId(context.getCompanyId());
		vo.setOrgId(context.getOrgId());
		vo.setSiteId(context.getSiteId());
		vo.setTerminalName(terminalName);
		vo.setBannerName(bannerName);
		try {
			List<ImageListVO> result = null;
			if(vo != null && BannerNameEnum.TRAIN_EXAM.getKey().equals(vo.getBannerName())){
				List<TrainingProjectVo> list = trainingProjectClient.getTop();
				if (!CollectionUtils.isEmpty(list)) {
					result = new ArrayList<ImageListVO>(1);
					for(TrainingProjectVo item : list){
						ImageListVO img = new ImageListVO();
						img.setImgTitle(item.getName());
						img.setId(item.getId());
						img.setBannerPath(item.getLogoImg());
						img.setCreateByName(item.getCreateByName());
						img.setCreateTime(item.getCreateTime());
						result.add(img);
					}
				}
			} else if(vo != null && BannerNameEnum.RESEARCH.getKey().equals(vo.getBannerName())){
				List<ResearchVo> list = researchClient.getResearchTop(null);//获取所有类型的置顶
				if (!CollectionUtils.isEmpty(list)) {
					result = new ArrayList<ImageListVO>(1);
					for(ResearchVo item : list){
						ImageListVO img = new ImageListVO();
						img.setImgTitle(item.getName());
						img.setId(item.getId());
						img.setBannerPath(item.getLogoImg());
						img.setCreateByName(item.getCreateByName());
						img.setCreateTime(item.getCreateTime());
						result.add(img);
					}
				}
			} else {
				result = bannerManageFeignClients.listAllHomeBannerImage(vo);
			}
			return Response.ok(result);
		} catch (Exception e) {
			LOGGER.error("所有首页 轮播图：" + e);
			return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
		}
	}
}
