package com.yizhi.application.customProject.contoller;


import com.yizhi.core.application.file.constant.FileConstant;
import com.yizhi.core.application.file.util.OssUpload;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author Ding
 * @className ExternalExperienceModelImport
 * @description TODO
 * @date 2018/11/20
 **/

@Component
public class ExternalExperienceModelExport {

    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalExperienceModelExport.class);

    public String importPoolActivityExperiencesModel(String poolName) throws IOException {

        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet("外部经验导入模板");
        HSSFRow row = sheet.createRow(0);
        row.createCell(0).setCellValue("用户名");
        row.createCell(1).setCellValue("所获外部经验");

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

        Date submitTime = new Date();

        String fileName = poolName + "经验规则导出" + sdf.format(submitTime) + ".xls";

//        String requestPath = "/Users/dingxiaowei/aaa";
        String requestPath = FileConstant.SAVE_PATH;
        File fileDir = new File(requestPath);
        if (!fileDir.exists()) {
            fileDir.mkdir();
        }

        String path = requestPath + "/" + fileName;
        FileOutputStream os = null;
        File file = null;

        String url = null;
        try {
            os = new FileOutputStream(path);
            workbook.write(os);
            url = OssUpload.upload(path, fileName);//阿里云返回url
            file = new File(path);
        } catch (Exception e2) {
            LOGGER.error("导出外部经验模板下载", e2);
        } finally {
            if (os != null) {
                os.close();
            }
            if (workbook != null) {
                workbook.close();
            }
            if (file != null) {
                file.delete();
            }
        }
        return url;
    }
}
