package com.yizhi.application.portal.controller;

import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.site.application.feign.SiteManageFeignClients;
import com.yizhi.site.application.vo.site.SiteConfigVO;
import com.yizhi.site.application.vo.site.SiteVo;
import com.yizhi.site.application.vo.site.SystemSiteVO;
import com.yizhi.system.application.system.remote.SiteClient;
import com.yizhi.system.application.vo.SiteVO;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * pc 配置 名字和图标
 *
 * @author lilingye
 */

@Api(tags = "pc 配置 名字和图标")
@RestController
@RequestMapping("/manage/site/config")
public class SiteConfigController {


    @Autowired
    SiteManageFeignClients siteManageFeignClients;

    @Autowired
    SiteClient siteClient;

    /**
     * 更新网站的信息
     *
     * @param siteConfigVO
     * @return
     */
    @PostMapping("/update")
    public Response<SiteConfigVO> update(@RequestBody SiteConfigVO siteConfigVO) {
        SiteConfigVO siteConfig = siteManageFeignClients.update(siteConfigVO);
        if (siteConfig != null) {
            return Response.ok(siteConfig);
        } else {
            return Response.fail();
        }
    }

    /**
     * 获取网站的信息
     *
     * @return
     */
    @GetMapping("/get")
    public Response<SiteConfigVO> get() {

        RequestContext context = ContextHolder.get();
        SystemSiteVO siteVO = new SystemSiteVO();
        siteVO.setId(context.getSiteId());
        siteVO.setName(context.getSiteName());
        siteVO.setCompanyId(context.getCompanyId());
        siteVO.setAdminAccountId(context.getAccountId());

        return Response.ok(siteManageFeignClients.get(siteVO));

    }


}
