package com.yizhi.application.sign.controller;

import com.yizhi.application.report.research.vo.ReportResearchVo;
import com.yizhi.statistics.application.feign.StatisticsSignClient;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.enums.i18n.Constants;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "签到-下载报表", description = "签到-下载报表")
@RestController
@RequestMapping("/manage/export/sign")
public class ExportSignController {

    @Autowired
    private StatisticsSignClient statisticsSignClient;


    //迁到报表服务
//    @ApiOperation(value = "导出签到统计", notes = "导出签到统计")
//    @GetMapping("/group")
//    public Response<ReportResearchVo> reportSignGroup(
//            @ApiParam(value = "培训项目Id", required = false) @RequestParam(name = "projectId", required = false) Long projectId,
//            @ApiParam(value = "签到开始时间", required = false) @RequestParam(name = "startDate", required = false) String startDate,
//            @ApiParam(value = "签到结束时间", required = false) @RequestParam(name = "endDate", required = false) String endDate
//    ) {
//        try {
//            if(startDate == ""){
//                startDate = null;
//            }
//            if(endDate == ""){
//                endDate = null;
//            }
//            RequestContext context = ContextHolder.get();
//            Map<String, Object> map = new HashMap<String, Object>(64);
//            String serialNo = "SIGN-EXPORT-"+ System.currentTimeMillis();
//            String taskName = "签到列表_" + dateFormat.format(new Date());
//            map.put("taskName",taskName);
//            map.put("serialNo",serialNo);
//            map.put("projectId", projectId);
//            map.put("context", context);
//            map.put("startDate", startDate);
//            map.put("endDate", endDate);
//            downloadSign.execute(map, true);
//            return Response.ok("任务名称："+taskName+",任务序号:"+serialNo);
//        } catch (Exception e) {
//            e.printStackTrace();
//            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
//        }
//
//    }

    /**
     * 导出签到统计
     * @param projectId
     * @param kwd
     * @param startDate
     * @param endDate
     * @return
     */
    @ApiOperation(value = "导出签到统计", notes = "导出签到统计")
    @GetMapping("/group")
    public Response<ReportResearchVo> reportSignGroup(
            @ApiParam(value = "培训项目Id", required = false) @RequestParam(name = "projectId", required = false) Long projectId,
            @ApiParam(value = "培训项目名称关键字", required = false) @RequestParam(name = "kwd", required = false) String kwd,
            @ApiParam(value = "签到开始时间", required = false) @RequestParam(name = "startDate", required = false) String startDate,
            @ApiParam(value = "签到结束时间", required = false) @RequestParam(name = "endDate", required = false) String endDate
    ) {
        try {
            if (StringUtils.isNotBlank(kwd)) {
                kwd = kwd.trim();
            }
            String serialNo = statisticsSignClient.signGroupDownload(projectId, kwd, startDate, endDate);
            return Response.ok("导出成功:" + " " + "编号" + serialNo);
        } catch (Exception e) {
            e.printStackTrace();
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    //迁到报表服务
//    @ApiOperation(value = "导出签到详情统计", notes = "导出签到详情统计")
//    @GetMapping("/group/view")
//    public Response<ReportResearchVo> reportSignGroupView(
//            @ApiParam(value = "签到Id", required = true) @RequestParam(name = "id", required = true) Long id,
//            @ApiParam(value = "签到Id", required = true) @RequestParam(name = "signId", required = true) Long projectId,
//            @ApiParam(value = "签到开始时间", required = true) @RequestParam(name = "startDate", required = true) String startDate,
//            @ApiParam(value = "签到结束时间", required = true) @RequestParam(name = "endDate", required = true) String endDate,
//            @ApiParam(value = "部门编码或者名称", required = true) @RequestParam(name = "orgNameOrCode", required = false) String orgNameOrCode,
//            @ApiParam(value = "用户关键字", required = true) @RequestParam(name = "accountName", required = false) String accountName
//    ) {
//        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH/mm");
//        try {
//            if(startDate == ""){
//                startDate = null;
//            }
//            if(endDate == ""){
//                endDate = null;
//            }
//            if(orgNameOrCode !=null){
//                orgNameOrCode = orgNameOrCode.replace(" ","");
//            }
//            if(orgNameOrCode == ""){
//                orgNameOrCode = null ;
//            }
//            if(accountName !=null){
//                accountName = accountName.replace(""," ");
//            }
//            if(accountName == ""){
//                accountName = null;
//            }
//            RequestContext context = ContextHolder.get();
//            TrSign trSign = signManageClient.getSignByTime(projectId);
//            if (trSign == null) {
//                return Response.fail("该签到不存在");
//            }
//
//            Map<String, Object> map = new HashMap<String, Object>(64);
//            String serialNo = "USER-EXPORT-"+ format.format(new Date());
//            String taskName ="签到明细统计_"+ trSign.getTrainningProjectName()+"("+simpleDateFormat.format(trSign.getSignStartDate())
//                    +"～"+simpleDateFormat.format(trSign.getSignEndDate())+ ")_" + dateFormat.format(new Date());
//            map.put("id",id);
//            map.put("taskName",taskName);
//            map.put("serialNo",serialNo);
//            map.put("signId", projectId);
//            map.put("orgNameOrCode", orgNameOrCode);
//            map.put("accountName", accountName);
//            map.put("trSign", trSign);
//            map.put("context", context);
//            map.put("startDate", startDate);
//            map.put("endDate", endDate);
//            downloadSignDetails.execute(map, true);
//            return Response.ok("任务名称："+taskName+",任务序号:"+serialNo);
//        } catch (Exception e) {
//            e.printStackTrace();
//            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
//        }
//    }

    /**
     * 导出签到详情统计
     */
    @ApiOperation(value = "导出签到详情统计", notes = "导出签到详情统计")
    @GetMapping("/group/view")
    public Response<ReportResearchVo> reportSignGroupView(
            @ApiParam(value = "signId", required = true) @RequestParam(name = "id", required = true) Long id,
            @ApiParam(value = "signTimeId", required = true) @RequestParam(name = "signId", required = true) Long signId,
            @ApiParam(value = "签到开始时间", required = true) @RequestParam(name = "startDate", required = true) String startDate,
            @ApiParam(value = "签到结束时间", required = true) @RequestParam(name = "endDate", required = true) String endDate,
            @ApiParam(value = "部门编码或者名称", required = true) @RequestParam(name = "orgNameOrCode", required = false) String orgNameOrCode,
            @ApiParam(value = "用户关键字", required = true) @RequestParam(name = "accountName", required = false) String accountName
    ) {
        try {
            if (StringUtils.isNotBlank(orgNameOrCode)) {
                orgNameOrCode = orgNameOrCode.trim();
            }
            if (accountName != null) {
                accountName = accountName.trim();
            }
            String serialNo = statisticsSignClient.signViewDownload(id, signId, startDate, endDate, orgNameOrCode, accountName);
            return Response.ok("导出成功" + " " + "编号:" + serialNo);
        } catch (Exception e) {
            e.printStackTrace();
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }


    /**
     * 签到-按用户统计-导出签到统计数据
     * @param accountKwd
     * @param orgKwd
     * @param startDate
     * @param endDate
     * @return
     */
    @ApiOperation(value = "签到-按用户统计-导出签到统计数据", notes = "签到-按用户统计-导出签到统计数据")
    @GetMapping("/account/group/export")
    public Response<ReportResearchVo> signAccountGroupExport(
            @ApiParam(value = "用户关键字", required = false) @RequestParam(name = "accountKwd", required = false) String accountKwd,
            @ApiParam(value = "部门关键字", required = false) @RequestParam(name = "orgKwd", required = false) String  orgKwd,
            @ApiParam(value = "签到开始时间", required = true) @RequestParam(name = "startDate", required = true) String startDate,
            @ApiParam(value = "签到结束时间", required = true) @RequestParam(name = "endDate", required = true) String endDate
    ) {
        try {
            if (StringUtils.isNotBlank(accountKwd)) {
                accountKwd = accountKwd.trim();
            }
            if (orgKwd != null) {
                orgKwd = orgKwd.trim();
            }
            String serialNo = statisticsSignClient.signAccountGroupExport(accountKwd, orgKwd, startDate, endDate);
            return Response.ok("导出成功" + " " + "编号:" + serialNo);
        } catch (Exception e) {
            e.printStackTrace();
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }


    /**
     * 签到-按用户统计-导出全部签到统计数据和明细
     * @param accountKwd
     * @param orgKwd
     * @param startDate
     * @param endDate
     * @return
     */
    @ApiOperation(value = "签到-按用户统计-导出全部签到统计数据和明细", notes = "签到-按用户统计-导出全部签到统计数据和明细")
    @GetMapping("/account/group/exportAll")
    public Response<ReportResearchVo> signAccountGroupExportAll(
            @ApiParam(value = "用户关键字", required = false) @RequestParam(name = "accountKwd", required = false) String accountKwd,
            @ApiParam(value = "部门关键字", required = false) @RequestParam(name = "orgKwd", required = false) String  orgKwd,
            @ApiParam(value = "签到开始时间", required = true) @RequestParam(name = "startDate", required = true) String startDate,
            @ApiParam(value = "签到结束时间", required = true) @RequestParam(name = "endDate", required = true) String endDate
    ) {
        try {
            if (StringUtils.isNotBlank(accountKwd)) {
                accountKwd = accountKwd.trim();
            }
            if (orgKwd != null) {
                orgKwd = orgKwd.trim();
            }
            String serialNo = statisticsSignClient.signAccountGroupExportAll(accountKwd, orgKwd, startDate, endDate);
            return Response.ok("导出成功" + " " + "编号:" + serialNo);
        } catch (Exception e) {
            e.printStackTrace();
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }


    /**
     * 签到-按用户统计-查看详情-下载全部数据
     * @param accountId
     * @param projectKwd
     * @param startDate
     * @param endDate
     * @return
     */
    @ApiOperation(value = "签到-按用户统计-查看详情-下载全部数据", notes = "签到-按用户统计-查看详情-下载全部数据")
    @GetMapping("/account/group/view/export")
    public Response<ReportResearchVo> signAccountViewExport(
            @ApiParam(value = "用户id", required = true) @RequestParam(name = "accountId", required = true) Long accountId,
            @ApiParam(value = "用户名", required = true) @RequestParam(name = "accountName", required = true) String accountName,
            @ApiParam(value = "项目关键字", required = false) @RequestParam(name = "projectKwd", required = false) String  projectKwd,
            @ApiParam(value = "签到开始时间", required = true) @RequestParam(name = "startDate", required = true) String startDate,
            @ApiParam(value = "签到结束时间", required = true) @RequestParam(name = "endDate", required = true) String endDate
    ) {
        try {
            if (StringUtils.isNotBlank(projectKwd)) {
                projectKwd = projectKwd.trim();
            }

            String serialNo = statisticsSignClient.signAccountViewExport(accountId, accountName, startDate, endDate, projectKwd);
            return Response.ok("导出成功" + " " + "编号:" + serialNo);
        } catch (Exception e) {
            e.printStackTrace();
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }
}
