package com.yizhi.application.enroll.controller;

import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.enroll.application.feign.EnrollFeignClient;
import com.yizhi.enroll.application.vo.IdEnrollVO;
import com.yizhi.point.application.feign.PointListenerClients;
import com.yizhi.site.application.feign.api.EventTrackApiClients;
import com.yizhi.training.application.feign.TpEnrollPassedClient;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.enums.i18n.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import javax.servlet.http.HttpServletRequest;
import java.util.Objects;

@Api(tags = "学员端接口", description = "学员端接口")
@RestController
@RequestMapping("/api/enroll")
public class EnrollApiController {

	private static final Logger LOG = LoggerFactory.getLogger(EnrollApiController.class);

	@Autowired
	private EnrollFeignClient enrollFeignClient;
	
	@Autowired
	private TpEnrollPassedClient tpEnrollPassedClient;

	@Autowired
	private PointListenerClients pointListenerClients;

	@Autowired
	private EventTrackApiClients eventTrackApiClients;
	@Autowired
	private RedisCache redisCache;

	@ApiOperation(value = "添加学员报名信息", notes = "添加学员报名信息")
	@PostMapping("/student")
	@ApiImplicitParams({
		@ApiImplicitParam(name = "id", value = "培训项目ID"),
	})
	public Response<String> insertTrEnrollRecord(HttpServletRequest request, @RequestBody IdEnrollVO vo) {
		try {
			if (vo.getId() == null) {
				return Response.fail("参数错误");
			}
			RequestContext requestContext = ContextHolder.get();
			Long id = enrollFeignClient.insertTrEnrollRecord(vo.getId()); 
			if(id == null){
				return Response.fail("2010", "报名已满", "");
			}
			tpEnrollPassedClient.insertTpStudentEnrollPassed(vo.getId(), id);
			pointListenerClients.addPoint("CreditClendarDone", id);

			// 添加学院报名埋点
			//if(request.getHeader("Cookie")!=null&& Objects.equals(redisCache.get(request.getHeader("Cookie").replace("JSESSIONID=","")),"2")){
				eventTrackApiClients.addEvent("event_enroll_student",vo.getId());
			//}
			return Response.ok(id);
		} catch (Exception e) {
			LOG.error("添加学员报名信息:" + e);
			return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
		}
	}
	
//	@ApiOperation(value = "添加学员报名信息", notes = "添加学员报名信息")
//	@PostMapping("/select")
//	@ApiImplicitParams({
//		@ApiImplicitParam(name = "idList", value = "培训项目ID 集合"),
//	})
//	public Response<List<TrainningEnrollVO>> selectTrEnrollRecord(@RequestBody IdListVO vo) {
//		try {
//			List<TrainningEnrollVO> list = enrollFeignClient.selectTrainningEnroll(vo.getIdList());
//			return Response.ok(list);
//		} catch (Exception e) {
//			LOG.error("添加学员报名信息:" + e);
//			return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
//		}
//	}
@ApiOperation(value = "PC端添加学员报名信息", notes = "添加学员报名信息")
@PostMapping("/pc/insert")
@ApiImplicitParams({@ApiImplicitParam(name = "id", value = "培训项目ID"),})
public Response<String> pcInsertTrEnrollRecord(@RequestBody IdEnrollVO vo) {
	try {
		if (vo.getId() == null) {
			return Response.fail("参数错误");
		}
		Long id = enrollFeignClient.insertTrEnrollRecord(vo.getId());
		return Response.ok(id);
	} catch (Exception e) {
		LOG.error("添加学员报名信息:" + e);
		return Response.fail(Constants.MSG_BIZ_FAIL.getCode().toString(),Constants.MSG_BIZ_FAIL.getName());
	}
}
	
}
