package com.yizhi.application.research.controller;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.research.application.feign.ResearchClient;
import com.yizhi.research.application.vo.BaseModel;
import com.yizhi.research.application.vo.api.CheckResearchStateVo;
import com.yizhi.research.application.vo.api.PageVo;
import com.yizhi.research.application.vo.api.SearchVo;
import com.yizhi.research.application.vo.domain.ResearchVo;
import com.yizhi.research.application.vo.domain.TrResearchQuestionVo;
import com.yizhi.site.application.feign.api.EventTrackApiClients;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.List;
import java.util.Objects;


/**
 * @Author: shengchenglong
 * @Date: 2018/3/17 15:55
 */
@Api(tags = "调研接口")
@RestController
@RequestMapping("/api/research")
public class ResearchController {

    private static final Logger LOGGER = LoggerFactory.getLogger(ResearchController.class);

    @Autowired
    private ResearchClient researchClient;

    @GetMapping("/page/list")
    @ApiOperation(value = "分页查询学员能看到的调研", notes = "分两种状态", response = ResearchVo.class)
    public Response<ResearchVo> listPage(
                                         @ApiParam(name = "state", value = "状态：1已完成，2进行中", required = false) @RequestParam(name = "state", required = false) Integer state,
                                         @ApiParam(name = "bizType", value = "业务类型：1调研；2投票，为空查询所有", required = false) @RequestParam(name = "bizType", required = false) Integer bizType,
                                         @ApiParam(name = "pageNo", value = "跳转页数,默认第一页", required = true) @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                         @ApiParam(name = "pageSize", value = "每页条数,默认20条", required = true) @RequestParam(name = "pageSize", defaultValue = "20") Integer pageSize
    ) {
        try {
            PageVo pageVo = new PageVo();

            pageVo.setAccountId(ContextHolder.get().getAccountId());
            System.out.println("accountId:"+ContextHolder.get().getAccountId());
            pageVo.setDate(new Date());
            pageVo.setPageNo(pageNo);
            pageVo.setPageSize(pageSize);
            pageVo.setState(state);
            pageVo.setBizType(bizType);
            com.yizhi.research.application.vo.BaseModel<PageVo> model = new BaseModel<>();
            model.setDate(new Date());
            model.setObj(pageVo);
            model.setContext(ContextHolder.get());

            return Response.ok(researchClient.apiListPage(model));
        } catch (Exception e) {
            LOGGER.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    @GetMapping("/search/page/list")
    @ApiOperation(value = "分页查询学员能看到的调研", notes = "分两种状态", response = ResearchVo.class)
    public Response<List<ResearchVo>> searchResearch(
            @ApiParam(name = "name", value = "模糊搜索关键词", required = true) @RequestParam("name") String name,

            @ApiParam(name = "pageNo", value = "跳转页数,默认第一页", required = true) @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
            @ApiParam(name = "pageSize", value = "每页条数,默认20条", required = true) @RequestParam(name = "pageSize", defaultValue = "20") Integer pageSize
    ) {
        try {
            SearchVo searchVo = new SearchVo();
            searchVo.setContext(ContextHolder.get());
            searchVo.setName(name);
            searchVo.setPageNo(pageNo);
            searchVo.setPageSize(pageSize);

            return Response.ok(researchClient.apiSearchPage(searchVo));
        } catch (Exception e) {
            LOGGER.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }
    @PostMapping("/state/check")
    @ApiOperation(value = "查询某个学员的某个调研的状态", response = TrResearchQuestionVo.class)
    public Response<Integer> checkResearchState(
    		@ApiParam(name = "researchId", value = "调研id", required = true)
    		@RequestBody CheckResearchStateVo checkResearchStateVo){
    	RequestContext context=ContextHolder.get();
    	checkResearchStateVo.setContext(context);
    	try{
    		return Response.ok(researchClient.checkResearchState(checkResearchStateVo));
    	}catch(Exception e){
    		e.printStackTrace();
    		return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
    	}
    	
    }
    
    @PostMapping("/details")
    @ApiOperation(value = "查看调研详情")
    public Response<ResearchVo> getResearchDetails(
    		@ApiParam(name = "researchId", value = "调研id", required = true)
    		@RequestBody CheckResearchStateVo checkResearchStateVo){
    	try{
    		return Response.ok(researchClient.getResearchDetails(checkResearchStateVo.getResearchId()));
    	}catch(Exception e){
    		e.printStackTrace();
    		return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
    	}
    	
    }
}
