package com.yizhi.application.util;

import com.yizhi.core.application.cache.CacheNamespace;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.util.application.json.JsonUtil;
import com.yizhi.util.application.sensitive.SensitivewordFilter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.HashSet;
import java.util.Set;

@Component
public  class FilterSensitiveWord {


    @Autowired
    private RedisCache redisCache;


    /**
     * 过滤敏感词
     *
     * @param content   评论内容
     * @return
     */
    public String filterWord(String content, Long companyId) {

        if (!StringUtils.isBlank(content)) {
            Set<String> sensitiveWordList = new HashSet<>();
            String sensitiveValues = (String) redisCache.hget(CacheNamespace.REDIS_SENSITIVE_WORD_INFO, companyId.toString());

            if (StringUtils.isNotBlank(sensitiveValues)) {
                sensitiveWordList = JsonUtil.json2Ojbect(sensitiveValues, Set.class);
                if (!CollectionUtils.isEmpty(sensitiveWordList)) {
                    return SensitivewordFilter.sensitiveFilter(content, sensitiveWordList);
                }
            }
        }
        return content;
    }
}
