package com.yizhi.application.caseLibrary.controller;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.accountUtil.AuthorizeQueryAccount;
import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.course.application.vo.RangeImportParamVo;
import com.yizhi.library.application.feign.StudentCaseClient;
import com.yizhi.library.application.feign.StudentCaseManageClient;
import com.yizhi.library.application.param.ExportAuditListParam;
import com.yizhi.library.application.param.StudentCaseAuditParam;
import com.yizhi.library.application.param.StudentCaseParam;
import com.yizhi.library.application.vo.*;
import com.yizhi.site.application.feign.PortalManagePCFeignClients;
import com.yizhi.site.application.vo.domain.ProtalPlateVo;
import com.yizhi.system.application.vo.AccountVO;
import com.yizhi.system.application.vo.OrgVO;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.enums.i18n.Constants;
import io.swagger.annotations.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Ding
 * @className StudentCaseManageController
 * @description TODO
 * @date 2019/7/19
 **/

@Api(tags = "管理端管理学员案例接口", description = "管理端管理学员案例接口")
@RestController
@RequestMapping("/manage/studentCase")
public class StudentCaseManageController {

    private static final Logger LOGGER = LoggerFactory.getLogger(StudentCaseManageController.class);

    @Autowired
    private StudentCaseClient studentCaseClient;

    @Autowired
    private StudentCaseManageClient studentCaseManageClient;

    @Autowired
    private AuthorizeQueryAccount queryAccount;

    @Autowired
    private PortalManagePCFeignClients portalManagePCFeignClient;


    @ApiOperation(value = "案例管理列表", notes = "案例管理列表", response = StudentCaseManageListVO.class)
    @GetMapping("/list")
    public Response<StudentCaseManageListVO> studentCaseManageList(@ApiParam(value = "案例活动id", required = true) @RequestParam(name = "caseLibraryId", required = true) Long caseLibraryId,
                                                            @ApiParam(value = "案例名称模糊查询", required = false) @RequestParam(name = "studentCaseName", required = false) String studentCaseName,
                                                            @ApiParam(value = "用户名/姓名", required = false) @RequestParam(name = "accountName", required = false) String accountName,
                                                            @ApiParam(value = "审核/评分状态模糊查询 不传:全部 1:待审核 2:不通过 3:待评分 4:已评分", required = false) @RequestParam(name = "state", required = false) Integer state,
                                                            @ApiParam(value = "部门关键字模糊查询", required = false) @RequestParam(name = "orgName", required = false) String orgName,
                                                            @ApiParam(value = "当前第几页", required = true) @RequestParam(name = "pageNo", required = true) Integer pageNo,
                                                            @ApiParam(value = "每页条数", required = true) @RequestParam(name = "pageSize", required = true) Integer pageSize) {

        try {
            Page<StudentCaseManageListVO> page = new Page<>(pageNo, pageSize);
            page = studentCaseManageClient.studentCaseManageList(caseLibraryId, studentCaseName, accountName, state, orgName, pageNo, pageSize);

            Map<String, Integer> pageMap = new HashMap<>(3);
            pageMap.put("pageNo", pageNo);
            pageMap.put("pageSize", pageSize);
            if (null != page) {
                pageMap.put("total", page.getTotal());
            }

            return Response.ok(page, pageMap);
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "案例管理列表获取记录数", notes = "案例管理列表获取记录数")
    @GetMapping("/list/getCount")
    public Response<Object> getCount(@ApiParam(value = "案例活动id", required = true) @RequestParam(name = "caseLibraryId", required = true) Long caseLibraryId) {

        try {
            return Response.ok(studentCaseManageClient.getManageListCount(caseLibraryId));
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "精选案例管理列表", notes = "精选案例管理列表", response = SelectionCaseListVO.class)
    @GetMapping("/selectionList")
    public Response<SelectionCaseListVO> getSelectionList(@ApiParam(value = "案例名称模糊查询", required = false) @RequestParam(name = "studentCaseName", required = false) String studentCaseName,
                                                   @ApiParam(value = "用户名/姓名", required = false) @RequestParam(name = "accountName", required = false) String accountName,
                                                   @ApiParam(value = "精选状态模糊查询 不传:全部 2:上架 3:下架", required = false) @RequestParam(name = "state", required = false) Integer state,
                                                   @ApiParam(value = "当前第几页", required = true) @RequestParam(name = "pageNo", required = true) Integer pageNo,
                                                   @ApiParam(value = "每页条数", required = true) @RequestParam(name = "pageSize", required = true) Integer pageSize) {

        try {
            Page<SelectionCaseListVO> page;
            //如果不为空去空格,如果为空直接赋null
            if (StringUtils.isNotBlank(studentCaseName)) {
                studentCaseName = studentCaseName.trim();
            } else {
                studentCaseName = null;
            }

            if (StringUtils.isNotBlank(accountName)) {
                accountName = accountName.trim();
            } else {
                accountName = null;
            }
            page = studentCaseManageClient.getSelectionList(studentCaseName, accountName, state, pageNo, pageSize);

            Map<String, Integer> pageMap = new HashMap<>(3);
            pageMap.put("pageNo", pageNo);
            pageMap.put("pageSize", pageSize);
            if (null != page) {
                pageMap.put("total", page.getTotal());
            }

            return Response.ok(page, pageMap);
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "精选案例管理列表下载报表", notes = "精选案例管理列表下载报表")
    @GetMapping("/selectionList/export")
    public Response<Object> selectionListExport(@ApiParam(value = "案例名称模糊查询", required = false) @RequestParam(name = "studentCaseName", required = false) String studentCaseName,
                                         @ApiParam(value = "用户名/姓名", required = false) @RequestParam(name = "accountName", required = false) String accountName,
                                         @ApiParam(value = "审核/评分状态模糊查询 不传:全部 2:上架 3:下架", required = false) @RequestParam(name = "state", required = false) Integer state) {

        try {

            //如果不为空去空格,如果为空直接赋null
            if (StringUtils.isNotBlank(studentCaseName)) {
                studentCaseName = studentCaseName.trim();
            } else {
                studentCaseName = null;
            }

            if (StringUtils.isNotBlank(accountName)) {
                accountName = accountName.trim();
            } else {
                accountName = null;
            }
            String serialNo = studentCaseManageClient.selectionListExport(studentCaseName, accountName, state);

            return Response.ok("导出成功," + " " + "编号:" + serialNo);
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "举报记录列表", notes = "举报记录列表", response = StudentCaseManageListVO.class)
    @GetMapping("/informList")
    public Response<StudentCaseManageListVO> getInformList(@ApiParam(value = "案例名称模糊查询", required = false) @RequestParam(name = "studentCaseName", required = false) String studentCaseName,
                                                    @ApiParam(value = "用户名/姓名", required = false) @RequestParam(name = "accountName", required = false) String accountName,
                                                    @ApiParam(value = "当前第几页", required = true) @RequestParam(name = "pageNo", required = true) Integer pageNo,
                                                    @ApiParam(value = "每页条数", required = true) @RequestParam(name = "pageSize", required = true) Integer pageSize) {

        try {
            Page<StudentCaseManageListVO> page;
            //如果不为空去空格,如果为空直接赋null
            if (StringUtils.isNotBlank(studentCaseName)) {
                studentCaseName = studentCaseName.trim();
            } else {
                studentCaseName = null;
            }

            if (StringUtils.isNotBlank(accountName)) {
                accountName = accountName.trim();
            } else {
                accountName = null;
            }
            page = studentCaseManageClient.getInformList(studentCaseName, accountName, pageNo, pageSize);

            Map<String, Integer> pageMap = new HashMap<>(3);
            pageMap.put("pageNo", pageNo);
            pageMap.put("pageSize", pageSize);
            if (null != page) {
                pageMap.put("total", page.getTotal());
            }

            return Response.ok(page, pageMap);
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "学员案例下架", notes = "学员案例下架")
    @GetMapping("/putDown")
    public Response<Object> putDown(@ApiParam(value = "学员案例id", required = true) @RequestParam(name = "studentCaseId", required = true) Long studentCaseId) {

        try {
            ProtalPlateVo protalPlate = new ProtalPlateVo();
            protalPlate.setLinkContent(studentCaseId);
            protalPlate.setState(1);
            ProtalPlateVo plate = portalManagePCFeignClient.getPlate(protalPlate);
            if (null != plate) {
                return Response.fail("4005", InternationalEnums.STUDENTCASEMANAGECONTROLLER1.getCode());
            } else {
                return Response.ok(studentCaseManageClient.putDown(studentCaseId));
            }
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "学员案例上架", notes = "学员案例上架")
    @GetMapping("/release")
    public Response<Object> release(@ApiParam(value = "学员案例id", required = true) @RequestParam(name = "studentCaseId", required = true) Long studentCaseId) {

        try {

            return Response.ok(studentCaseManageClient.release(studentCaseId));
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "学员案例删除", notes = "学员案例删除")
    @GetMapping("/delete")
    public Response<Object> delete(@ApiParam(value = "学员案例id", required = true) @RequestParam(name = "studentCaseId", required = true) Long studentCaseId) {

        try {

            return Response.ok(studentCaseManageClient.delete(studentCaseId));
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "举报记录移除", notes = "举报记录移除")
    @GetMapping("/informList/remove")
    public Response<Object> informRecordRemove(@ApiParam(value = "举报记录id", required = true) @RequestParam(name = "informRecordId", required = true) Long informRecordId) {

        try {

            return Response.ok(studentCaseManageClient.informRecordRemove(informRecordId));
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "举报记录查看", notes = "举报记录查看", response = StudentCaseStudyVO.class)
    @GetMapping("/informList/view")
    public Response<StudentCaseStudyVO> informListView(@ApiParam(value = "举报记录id", required = false) @RequestParam(name = "informRecordId", required = false) Long informRecordId) {

        try {

            return Response.ok(studentCaseManageClient.informListView(informRecordId));
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "举报记录列表导出", notes = "举报记录列表导出")
    @GetMapping("/informList/export")
    public Response<Object> informListExport(@ApiParam(value = "案例名称模糊查询", required = false) @RequestParam(name = "studentCaseName", required = false) String studentCaseName,
                                      @ApiParam(value = "用户名/姓名", required = false) @RequestParam(name = "accountName", required = false) String accountName) {

        try {
            if (StringUtils.isNotBlank(studentCaseName)) {
                studentCaseName = studentCaseName.trim();
            } else {
                studentCaseName = null;
            }

            if (StringUtils.isNotBlank(accountName)) {
                accountName = accountName.trim();
            } else {
                accountName = null;
            }
            String serialNo = studentCaseManageClient.informListExport(studentCaseName, accountName);


            return Response.ok("导出成功," + " " + "编号:" + serialNo);
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "审核评分管理列表下载报表", notes = "审核评分管理列表下载报表")
    @GetMapping("/list/export")
    public Response<Object> exportStudentCaseManageList(@ApiParam(value = "案例活动名称", required = false) @RequestParam(name = "caseLibraryName", required = false) String caseLibraryName,
                                                 @ApiParam(value = "所属项目名称", required = false) @RequestParam(name = "trainingProjectName", required = false) String trainingProjectName,
                                                 @ApiParam(value = "案例活动id", required = true) @RequestParam(name = "caseLibraryId", required = true) Long caseLibraryId,
                                                 @ApiParam(value = "案例名称模糊查询", required = false) @RequestParam(name = "studentCaseName", required = false) String studentCaseName,
                                                 @ApiParam(value = "用户名/姓名", required = false) @RequestParam(name = "accountName", required = false) String accountName,
                                                 @ApiParam(value = "审核/评分状态模糊查询 不传:全部 1:待审核 2:不通过 3:待评分 4:已评分", required = false) @RequestParam(name = "state", required = false) Integer state) {

        try {

            String serialNo = studentCaseManageClient.exportStudentCaseManageList(caseLibraryName, trainingProjectName, caseLibraryId, studentCaseName, accountName, state);

            return Response.ok("导出成功," + " " + "编号:" + serialNo);
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "studentCaseIds", value = "待审核案例id", paramType = "body", required = true),
            @ApiImplicitParam(name = "caseLibraryName", value = "案例活动名称", paramType = "body", required = false),
            @ApiImplicitParam(name = "trainingProjectName", value = "所属项目名称", paramType = "body", required = false)
    })
    @ApiOperation(value = "导出待审核案例", notes = "导出待审核案例")
    @PostMapping("/auditList/export")
    public Response<Object> exportAuditList(@RequestBody ExportAuditListParam param) {

        try {
            if (CollectionUtils.isEmpty(param.getStudentCaseIds())) {
                return Response.fail("4002", InternationalEnums.STUDENTCASEMANAGECONTROLLER2.getCode());

            }
            String serialNo = studentCaseManageClient.exportAuditList(param);

            return Response.ok("导出成功," + " " + "编号:" + serialNo);
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "导入审核结果", notes = "导入审核结果")
    @PostMapping("/auditList/import")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ossUrl", value = "上传阿里云返回url", paramType = "body", required = true)
    })
    public Response<Object> importAuditList(@RequestBody RangeImportParamVo paramVo) {

        try {
            String serialNo = studentCaseManageClient.importAuditList(paramVo.getOssUrl());
            return Response.ok("导入成功," + " " + "编号:" + serialNo);
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "studentCaseIds", value = "待审核案例id", paramType = "body", required = true),
            @ApiImplicitParam(name = "caseLibraryName", value = "案例活动名称", paramType = "body", required = false),
            @ApiImplicitParam(name = "trainingProjectName", value = "所属项目名称", paramType = "body", required = false)
    })
    @ApiOperation(value = "导出待评分案例", notes = "导出待评分案例")
    @PostMapping("/scoreList/export")
    public Response<Object> exportScoreList(@RequestBody ExportAuditListParam param) {

        try {

            if (CollectionUtils.isEmpty(param.getStudentCaseIds())) {
                return Response.fail("4002", InternationalEnums.STUDENTCASEMANAGECONTROLLER2.getCode());
            }

            String serialNo = studentCaseManageClient.exportScoreList(param);

            return Response.ok("导出成功," + " " + "编号:" + serialNo);
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "导入评分结果", notes = "导入评分结果")
    @PostMapping("/scoreList/import")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ossUrl", value = "上传阿里云返回url", paramType = "body", required = true)
    })
    public Response<Object> importScoreList(@RequestBody RangeImportParamVo paramVo) {

        try {
            String serialNo = studentCaseManageClient.importScoreList(paramVo.getOssUrl());
            return Response.ok("导入成功," + " " + "编号:" + serialNo);
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "学员案例审核/评分获取学员案例信息", notes = "学员案例审核/评分获取学员案例信息", response = StudentCaseStudyVO.class)
    @GetMapping("/auditOrScoreView")
    public Response<StudentCaseStudyVO> studentCaseManageAuditOrScoreView(@ApiParam(value = "学员案例id", required = true) @RequestParam(name = "studentCaseId", required = true) Long studentCaseId,
                                                                   @ApiParam(value = "案例活动id/弃用", required = false) @RequestParam(name = "caseLibraryId", required = false) Long caseLibraryId,
                                                                   @ApiParam(value = "案例名称模糊查询/弃用", required = false) @RequestParam(name = "studentCaseName", required = false) String studentCaseName,
                                                                   @ApiParam(value = "用户名/姓名/弃用", required = false) @RequestParam(name = "accountName", required = false) String accountName,
                                                                   @ApiParam(value = "审核/评分状态模糊查询 不传:全部 1:待审核 2:不通过 3:待评分 4:已评分", required = false) @RequestParam(name = "state", required = false) Integer state,
                                                                   @ApiParam(value = "部门关键字模糊查询/弃用", required = false) @RequestParam(name = "orgName", required = false) String orgName,
                                                                   @ApiParam(value = "当前第几条数据/弃用", required = false) @RequestParam(name = "number", required = false) Integer number) {

        try {
            return Response.ok(studentCaseManageClient.studentCaseManageAuditOrScoreView(studentCaseId, caseLibraryId, studentCaseName, accountName, state, orgName, number));
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "学员案例审核提交", notes = "学员案例审核提交")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "studentCaseId", value = "学员案例id", paramType = "body", required = true),
            @ApiImplicitParam(name = "auditState", value = "审核是否通过 0:不通过 1:通过", paramType = "body", required = true),
            @ApiImplicitParam(name = "audiEvaluate", value = "审核反馈", paramType = "body", required = false)
    })
    @PostMapping("/audit")
    public Response<Object> studentCaseAudit(@RequestBody StudentCaseAuditParam studentCaseAuditParam) {

        try {
            return Response.ok(studentCaseClient.studentCaseAudit(studentCaseAuditParam));
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "学员案例批量审核", notes = "学员案例批量审核")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "idList", value = "学员案例id", paramType = "body", required = true),
            @ApiImplicitParam(name = "auditState", value = "审核是否通过 0:不通过 1:通过", paramType = "body", required = true),
            @ApiImplicitParam(name = "audiEvaluate", value = "审核反馈", paramType = "body", required = false)
    })
    @PostMapping("/batchAudit")
    public Response<Object> studentCaseBatchAudit(@RequestBody StudentCaseAuditParam studentCaseAuditParam) {

        try {
            if (CollectionUtils.isEmpty(studentCaseAuditParam.getIdList())) {
                return Response.fail("4002", InternationalEnums.STUDENTCASEMANAGECONTROLLER2.getCode());
            }
            return Response.ok(studentCaseClient.studentCaseBatchAudit(studentCaseAuditParam));
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "学员案例评分提交", notes = "学员案例评分提交")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "studentCaseId", value = "学员案例id", paramType = "body", required = true),
            @ApiImplicitParam(name = "score", value = "评分", paramType = "body", required = true)
    })
    @PostMapping("/score")
    public Response<Object> studentCaseScore(@RequestBody StudentCaseAuditParam studentCaseAuditParam) {

        try {
            studentCaseAuditParam.setIsAdmin(1);
            return Response.ok(studentCaseClient.studentCaseScore(studentCaseAuditParam));
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "学员案例批量评分", notes = "学员案例批量评分")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "idList", value = "学员案例id", paramType = "body", required = true),
            @ApiImplicitParam(name = "score", value = "审核反馈", paramType = "body", required = true)
    })
    @PostMapping("/batchScore")
    public Response<Object> studentCaseBatchScore(@RequestBody StudentCaseAuditParam studentCaseAuditParam) {

        try {
            studentCaseAuditParam.setIsAdmin(1);
            if (CollectionUtils.isEmpty(studentCaseAuditParam.getIdList())) {
                return Response.fail("4002", InternationalEnums.STUDENTCASEMANAGECONTROLLER2.getCode());
            }
            return Response.ok(studentCaseClient.studentCaseBatchScore(studentCaseAuditParam));
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "管理端管理学员案例批量导出案例附件", notes = "管理端管理学员案例批量导出案例附件")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "idList", value = "学员案例id", paramType = "body", required = true)
    })
    @PostMapping("/batchExport")
    public Response<Object> batchExport(@RequestBody StudentCaseAuditParam studentCaseAuditParam) {

        try {
            if (CollectionUtils.isEmpty(studentCaseAuditParam.getIdList())) {
                return Response.fail("4002", InternationalEnums.STUDENTCASEMANAGECONTROLLER2.getCode());
            }
            String serialNo = studentCaseClient.studentCaseBatchExport(studentCaseAuditParam);
            return Response.ok("导出成功," + " " + "编号:" + serialNo);
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "管理端查看,修改学员案例获取案例信息", notes = "管理端查看,修改学员案例获取案例信息", response = StudentCaseViewVO.class)
    @GetMapping("/view")
    public Response<StudentCaseViewVO> studentCaseView(@ApiParam(value = "学员案例id", required = true) @RequestParam(name = "studentCaseId", required = true) Long studentCaseId,
                                                @ApiParam(value = "不传,学员端,1:管理端", required = false) @RequestParam(name = "type", required = false) Integer type) {

        try {
            return Response.ok(studentCaseClient.studentCaseView(studentCaseId, type));
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "管理端代提交获取案例库信息", notes = "管理端代提交获取案例库信息", response = StudentCaseVO.class)
    @GetMapping("/prepareStudentCase")
    public Response<StudentCaseVO> prepareStudentCase(@ApiParam(value = "案例活动id", required = true) @RequestParam(name = "caseLibraryId", required = true) Long caseLibraryId) {

        try {
            StudentCaseVO studentCaseVO = studentCaseClient.prepareStudentCase(caseLibraryId);
            if (null != studentCaseVO.getResultState() && studentCaseVO.getResultState() == 0) {
                //返回案例活动已经下架,不能参加
                return Response.fail("4006", InternationalEnums.STUDENTCASEMANAGECONTROLLER3.getCode());
            } else {
                return Response.ok(studentCaseVO);
            }

        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "管理端修改学员案例提交", notes = "管理端修改学员案例提交")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "title", value = "学员案例主题", paramType = "body", required = false),
            @ApiImplicitParam(name = "logoUrl", value = "学员案例封面图片", paramType = "body", required = false),
            @ApiImplicitParam(name = "caseLibraryId", value = "案例活动id", paramType = "body", required = false),
            @ApiImplicitParam(name = "submitterId", value = "代提交id", paramType = "body", required = false),
            @ApiImplicitParam(name = "textEditType", value = "案例内容提交形式 1:文本编辑 2:导入外部文档", paramType = "body", required = false),
            @ApiImplicitParam(name = "content", value = "学员案例内容", paramType = "body", required = false),
            @ApiImplicitParam(name = "url", value = "附件url", paramType = "body", required = false),
            @ApiImplicitParam(name = "name", value = "附件名称", paramType = "body", required = false),
            @ApiImplicitParam(name = "fileSize", value = "文件大小", paramType = "body", required = false),
            @ApiImplicitParam(name = "type", value = "1:代提交 2:管理端修改保存 3:管理端修改上架", paramType = "body", required = false)
    })
    @PostMapping("/modify/submit")
    public Response<Object> submitStudentCase(@RequestBody StudentCaseParam studentCaseParam) {

        try {
            return Response.ok(studentCaseClient.submitStudentCase(studentCaseParam));
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "管理端修改学员案例新增可见范围用户,部门", notes = "管理端修改学员案例新增可见范围用户,部门")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "studentCaseId", value = "学员案例id", paramType = "body", required = true),
            @ApiImplicitParam(name = "relationId", value = "存放人或组织的ID", paramType = "body", required = true),
            @ApiImplicitParam(name = "type", value = "1：用户 、2：组织", paramType = "body", required = true),
            @ApiImplicitParam(name = "name", value = "角色名称", paramType = "body", required = false)
    })
    @PostMapping("/authorize/insert")
    public Response<Object> insertAuthorizes(@RequestBody List<StudentCaseAuthorizeVO> studentCaseAuthorizeList) {

        try {
            return Response.ok(studentCaseClient.insertAuthorizes(studentCaseAuthorizeList));
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "管理端修改学员案例获取可见范围列表", notes = "管理端修改学员案例获取可见范围列表", response = StudentCaseAuthorizeVO.class)
    @GetMapping("/authorize/list")
    public Response<StudentCaseAuthorizeVO> getAuthorize(@ApiParam(value = "学员案例id", required = true) @RequestParam(name = "studentCaseId", required = true) Long studentCaseId) {
        try {
            List<StudentCaseAuthorizeVO> authorizeVOList = studentCaseClient.getAuthorize(studentCaseId);
            if (CollectionUtils.isNotEmpty(authorizeVOList)) {
                List<Long> accountIds = new ArrayList<>();
                List<Long> orgIds = new ArrayList<>();
                Map<Long, AccountVO> accountVOMap = new HashMap<>(16);
                Map<Long, OrgVO> orgVOMap = new HashMap<>(16);
                //获取用户,部门信息
                for (StudentCaseAuthorizeVO studentCaseAuthorizeVO : authorizeVOList) {
                    if (studentCaseAuthorizeVO.getType() == 1) {
                        accountIds.add(studentCaseAuthorizeVO.getRelationId());
                    } else if (studentCaseAuthorizeVO.getType() == 2) {
                        orgIds.add(studentCaseAuthorizeVO.getRelationId());
                    }
                }
                if (CollectionUtils.isNotEmpty(accountIds)) {
                    accountVOMap = queryAccount.queryAccountByIds(accountIds);
                }
                if (CollectionUtils.isNotEmpty(orgIds)) {
                    orgVOMap = queryAccount.queryOrgByIds(orgIds);
                }
                for (StudentCaseAuthorizeVO studentCaseAuthorizeVO : authorizeVOList) {
                    if (studentCaseAuthorizeVO.getType() == 1) {
                        AccountVO accountVO = accountVOMap.get(studentCaseAuthorizeVO.getRelationId());
                        if (null != accountVO) {
                            studentCaseAuthorizeVO.setName(accountVO.getName());
                            studentCaseAuthorizeVO.setAccountFullName(accountVO.getFullName());
                            studentCaseAuthorizeVO.setWorkNum(accountVO.getWorkNum());
                        }
                    } else if (studentCaseAuthorizeVO.getType() == 2) {
                        OrgVO orgVO = orgVOMap.get(studentCaseAuthorizeVO.getRelationId());
                        if (null != orgVO) {
                            studentCaseAuthorizeVO.setName(orgVO.getName());
                        }
                    }
                }
            }
            return Response.ok(authorizeVOList);
        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "培训项目关联案例活动获取列表", notes = "培训项目关联案例活动获取列表", response = CaseLibraryVO.class)
    @GetMapping("/getProjectList")
    public Response<CaseLibraryVO> getProjectList(@ApiParam(value = "模糊查询", required = false) @RequestParam(name = "name", required = false) String name,
                                         @ApiParam(value = "当前第几页", required = true) @RequestParam(name = "pageNo", required = true) Integer pageNo,
                                         @ApiParam(value = "每页条数", required = true) @RequestParam(name = "pageSize", required = true) Integer pageSize) {

        try {
            Map<String, Integer> pageMap = new HashMap<>(3);
            Page<StudentCaseStudyVO> page = studentCaseClient.getProjectList(name, pageNo, pageSize);
            pageMap.put("pageNo", pageNo);
            pageMap.put("pageSize", pageSize);
            if (null != page) {
                pageMap.put("total", page.getTotal());
            }
            return Response.ok(page, pageMap);

        } catch (Exception e) {
            LOGGER.error("############案例库服务调用出现异常", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }
}
