package com.yizhi.application.course.controller;

import com.alibaba.fastjson.JSON;
import com.yizhi.application.course.vo.CardConfigInfoVO;
import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.course.application.feign.CardConfigClient;
import com.yizhi.course.application.vo.CardConfigVO;
import com.yizhi.system.application.system.remote.StudentEditPermissionClient;
import com.yizhi.system.application.vo.StudentEditPermissionVO;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Objects;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 16:29 2019/3/7
 * @Modified By
 */
@Api(tags="管理端-营销课程名片",description="名片的配置接口")
@RestController
@RequestMapping("/manage/cardConfig")
public class CardConfigController {

    @Autowired
    private CardConfigClient cardConfigClient;

    @Autowired
    private StudentEditPermissionClient permissionClient;

    private Logger logger = LoggerFactory.getLogger(CardConfigController.class);

    @ApiOperation(value = "保存名片配置",response = CardConfigInfoVO.class)
    @PostMapping("/save")
    public Response<CardConfigInfoVO> save(@RequestBody CardConfigInfoVO vo){

        logger.info("请求参数={}", JSON.toJSONString(vo));

        RequestContext rt = ContextHolder.get();

        Long id = vo.getPermissionVO().getId();
        if(Objects.isNull(id)){
            StudentEditPermissionVO permissionExits = permissionClient.getBySiteId(rt.getSiteId());
            if(permissionExits != null){
                return Response.fail(InternationalEnums.CARDCONFIGCONTROLLER.getName());
            }
        }

        // 保存个人编辑权限
        StudentEditPermissionVO savePermission = vo.getPermissionVO();
        savePermission.setCompanyId(rt.getCompanyId());
        savePermission.setSiteId(rt.getSiteId());
        savePermission.setCreateById(rt.getAccountId());
        savePermission.setCreateByName(rt.getAccountName());
        StudentEditPermissionVO permissionVO = permissionClient.saveOrUpdate(savePermission);
        if(permissionVO != null){
            vo.setPermissionVO(permissionVO);

            // 保存名片配置信息
            CardConfigVO saveCardConfig = vo.getCardConfigVO();
            saveCardConfig.setCompanyId(rt.getCompanyId());
            saveCardConfig.setSiteId(rt.getSiteId());
            saveCardConfig.setUpdateById(rt.getAccountId());
            saveCardConfig.setUpdateByName(rt.getAccountName());
            CardConfigVO cardConfigVO = cardConfigClient.addConfig(saveCardConfig);
            vo.setCardConfigVO(cardConfigVO);
        }

        return Response.ok(vo);
    }

    @ApiOperation(value = "获取当前站点-名片信息",response = CardConfigInfoVO.class)
    @GetMapping("/get")
    public Response<CardConfigInfoVO> getConfigBySiteId(){
        CardConfigInfoVO vo = null;
        RequestContext rt = ContextHolder.get();
        long siteId = rt.getSiteId();
        // 保存个人编辑权限
        StudentEditPermissionVO permissionVO = permissionClient.getBySiteId(siteId);
        if(permissionVO != null){
            vo = new CardConfigInfoVO();
            vo.setPermissionVO(permissionVO);
            // 保存名片配置信息
            CardConfigVO cardConfigVO = cardConfigClient.getBySiteId(siteId);
            vo.setCardConfigVO(cardConfigVO);
        }
        return Response.ok(vo);
    }

    @ApiOperation(value = "检查名片配置是否存在 true 表示该站点存在配置，false表示不存在")
    @GetMapping("/check/config/extis")
    public Response<Boolean> checkConfigExtis(){
        RequestContext rt = ContextHolder.get();
        logger.info("上下文信息={}",JSON.toJSONString(rt));
        CardConfigVO cardConfigVO = cardConfigClient.getBySiteId(rt.getSiteId());
        if(cardConfigVO == null){
            return Response.ok(false);
        }
        return Response.ok(true);
    }

    @ApiOperation(value = "初始化名片配置信息")
    @GetMapping("/init")
    public Response<Boolean> initConfig(@RequestParam("siteId") Long siteId){
        return Response.ok(cardConfigClient.initConfig(siteId));
    }
}
