package com.yizhi.application.course.controller;

import com.alibaba.fastjson.JSON;

import com.yizhi.course.application.feign.ClassifyGroupClient;
import com.yizhi.course.application.vo.ClassifyGroupInfoVO;
import com.yizhi.course.application.vo.ClassifyGroupStudentVO;
import com.yizhi.course.application.vo.ClassifyGroupVO;
import com.yizhi.course.application.vo.GroupClassifyItemVO;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/manage/classify/group")
@Api(tags = "管理端-课程分类组", description = "课程分类组接口")
public class ClassifyGroupController {

    @Autowired
    private ClassifyGroupClient classifyGroupClient;

    private static final Logger logger = LoggerFactory.getLogger(ClassifyGroupController.class);
    /**
     * 保存分类和组的关联数据
     * @param classifyGroupInfoVO
     * @return
     */
    @PostMapping("/save")
    @ApiOperation(value = "组关联分类,勾选分类进行保存的接口（作增量保存时候考虑）", response = GroupClassifyItemVO.class)
    public Response<ClassifyGroupVO> save(@RequestBody ClassifyGroupInfoVO classifyGroupInfoVO){
        List<ClassifyGroupVO> saveObj =  classifyGroupClient.save(classifyGroupInfoVO);
        return Response.ok(saveObj);
    }

    @PostMapping("/save/all")
    @ApiOperation(value = "组关联分类,勾选分类进行保存的接口(统一一次保存）", response = ClassifyGroupVO.class)
    public Response<ClassifyGroupVO> saveAll(@RequestBody ClassifyGroupInfoVO classifyGroupInfoVO){
        logger.info("classifyGroupInfoVO=", JSON.toJSONString(classifyGroupInfoVO));
        List<ClassifyGroupVO> saveObj =  classifyGroupClient.saveAll(classifyGroupInfoVO);
        return Response.ok(saveObj);
    }

    @GetMapping("/get")
    @ApiOperation(value = "添加课程分类操作时，对课程分类查看接口（分层级获取回显的分类列表）", response = GroupClassifyItemVO.class)
    public Response<GroupClassifyItemVO> get(@ApiParam(name = "id", value = "课程分类组id", required = true) @RequestParam("id") Long id,
                                             @ApiParam(name = "classifyId", value = "点击的课程类型id") @RequestParam(value = "classifyId" ,required = false) Long classifyId,
                                             @ApiParam(name = "layer", value = "点击分类以后，传入要数据要渲染的层级（该情况出现1的情况。2表示2级；3表示3级") @RequestParam(value = "layer",required = false) Integer layer) {
        List<GroupClassifyItemVO> infoData = classifyGroupClient.get(id, classifyId, layer);
        return Response.ok(infoData);
    }

    @GetMapping("/get/select/classifyIds")
    @ApiOperation(value = "添加课程分类操作时，对课程分类查看接口，返回勾选的分类ids（统一返回）")
    public Response<Long> getSelect(@ApiParam(name = "id", value = "课程分类组id", required = true) @RequestParam("id") Long id) {
        List<Long> infoData = classifyGroupClient.getSelectIds(id);
        return Response.ok(infoData);
    }


    @ApiOperation(value = "管理端，返回选择的分类信息列表")
    @GetMapping("/get/select/classify")
    public Response<ClassifyGroupStudentVO> view(
            @ApiParam(name = "id", value = "根据分类组的id获取关联的分类详细信息（平铺课程分类信息）", required = true) @RequestParam(name = "id") Long id,
            @ApiParam(name = "keyName", value = "分类名模糊搜索", required = false) @RequestParam(name = "keyName",required = false) String keyName){
        //return Response.ok(classifyGroupInfoClient.view(id));
        return Response.ok(classifyGroupClient.manageView(id,keyName));
    }

}
