package com.yizhi.application.course.controller;


import com.baomidou.mybatisplus.plugins.Page;

import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.course.application.feign.ProjectCourseClient;
import com.yizhi.course.application.vo.ProjectCourseVo;
import com.yizhi.course.application.vo.ProjectSeachCourseVo;
import com.yizhi.course.application.vo.domain.ProjectCourseEntityVo;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;


/**
 * <p>
 * 课程 前端控制器
 * </p>
 *
 * @author wenjunlong
 * @since 2018-03-19
 */
@Api(tags="管理端-课程培训项目",description="项目课程相关接口")
@RestController
@RequestMapping("/manage/project")
public class ProjectCourseController {

    @Autowired
    ProjectCourseClient projectCourseClient;

    @GetMapping("/course/list")
    @ApiOperation(value = "项目未关联课程分页查询", notes = "返回分页结果集",response = ProjectCourseVo.class)
    public Response list(
            @ApiParam(name = "id", value = "培训项目id", required = true) @RequestParam(name = "id", required = false) Long id,
            @ApiParam(name = "name", value = "课程名称或标签", required = false) @RequestParam(name = "name", required = false) String name,
            @ApiParam(name = "classifyId", value = "分类id ", required = false) @RequestParam(name = "classifyId", required = false) Long classifyId,
            @ApiParam(name = "pageNo", value = "跳转页数,默认第一页", required = true) @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
            @ApiParam(name = "pageSize", value = "每页条数,默认20条", required = true) @RequestParam(name = "pageSize", defaultValue = "20") Integer pageSize) {

        ProjectSeachCourseVo projectSeachCourseVo = new ProjectSeachCourseVo();
        projectSeachCourseVo.setName(name);
        projectSeachCourseVo.setTrainingProjectId(id);
        projectSeachCourseVo.setClassifyId(classifyId);
        projectSeachCourseVo.setPageNo(pageNo);
        projectSeachCourseVo.setPageSize(pageSize);
        RequestContext requestContext = ContextHolder.get();
        if (StringUtils.isEmpty(requestContext)) {
            projectSeachCourseVo.setCompanyId(0L);
        }else{
            if (requestContext.isAdmin()) {
                projectSeachCourseVo.setCompanyId(requestContext.getCompanyId());
            }else{
                projectSeachCourseVo.setSiteId(requestContext.getSiteId());
                if (requestContext.getOrgIds()!=null) {
                }

            }
        }
        Page<ProjectCourseVo> page  =    projectCourseClient.projectList(projectSeachCourseVo);
        return Response.ok(page);
    }


    @PostMapping("/save")
    @ApiOperation(value = "项目和课程关联", notes = "返回操作成功与否")
    public Response<String> save(@RequestBody ProjectCourseEntityVo projectCourse) {
        Boolean f = projectCourseClient.projectCourseSave(projectCourse);
        if (f) {
            return Response.ok("关联成功");
        } else {
            return Response.ok("关联失败");
        }
    }


    @PostMapping("/delete")
    @ApiOperation(value = "去掉项目和课程关联", notes = "返回操作成功与否")
    public Response<String> delete(@RequestBody ProjectCourseEntityVo projectCourse) {
        Boolean f = projectCourseClient.projectCourseDelete(projectCourse);
        if (f) {
            return Response.ok("删除关联成功");
        } else {
            return Response.ok("删除关联失败");
        }
    }

}
