package com.yizhi.application.course.controller;


import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import com.yizhi.course.application.feign.MaterialClient;
import com.yizhi.course.application.vo.AudioVideoVO;
import com.yizhi.course.application.vo.domain.MaterialEntityVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Api(tags = "管理端-课程完成记录", description = "课程完成记录接口")
@RestController
@RequestMapping("/manage/public/recorde")
public class RecordeController {

    private static final Logger LOG = LoggerFactory.getLogger(RecordeController.class);

    @Autowired
    MaterialClient materialClient;

    public static Map<String, Object> parseJSON2Map(String jsonStr) throws Exception {
        Map<String, Object> map = new HashMap<String, Object>();
        JSONObject json = JSONObject.parseObject(jsonStr);
        for (Object k : json.keySet()) {
            Object v = json.get(k);
            if (v instanceof JSONArray) {
                List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                JSONArray json2 = JSONArray.parseArray(v.toString());
                for (int i = 0; i < json2.size(); i++) {
                    // 遍历 jsonarray 数组，把每一个对象转成 json 对象
                    JSONObject job = json2.getJSONObject(i);
                    list.add(parseJSON2Map(job.toString()));
                }
                map.put(k.toString(), list);
            } else {
                map.put(k.toString(), v);
            }
        }
        return map;
    }

    @ApiOperation(value = "学习记录日志解析 保存到学习记录表中")
    @PostMapping("/analysis")
    public void analysis(@RequestBody String jsonStr) {
        LOG.info("回调事件：" + jsonStr);

        try {
            if (!StringUtils.isEmpty(jsonStr)) {
                Map<String, Object> playStr = parseJSON2Map(jsonStr);
                if ("TranscodeComplete".equals(playStr.get("EventType")) && "success".equals(playStr.get("Status"))) {

                    //根据videoid查询相应的实体进行 视频地址更新
                    if (playStr.containsKey("VideoId")) {

                        AudioVideoVO video = materialClient.videoView(playStr.get("VideoId").toString());
                        List<Map<String, Object>> playInfoList  = (List<Map<String, Object>>) playStr.get("StreamInfos");
                        LOG.info("播放list" + playInfoList);
                        Integer duration = 0;

                        if (null != video) {

                            for (int i = 0; i < playInfoList.size(); i++) {
                                // 遍历 jsonarray 数组，把每一个对象转成 json 对象
                                Map<String, Object> job = playInfoList.get(i);

                                if ("FD".equals(job.get("Definition").toString())) {
                                    video.setFdUrl(job.get("FileUrl").toString());
                                    duration = Double.valueOf(job.get("Duration").toString()).intValue();
                                } else if ("LD".equals(job.get("Definition").toString())) {
                                    video.setLdUrl(job.get("FileUrl").toString());
                                } else {
                                    video.setSdUrl(job.get("FileUrl").toString());
                                }

                            }

                            int hour = duration / 3600;
                            int minute = (duration - hour * 3600) / 60;
                            int second = (duration - hour * 3600 - minute * 60);
                            MaterialEntityVo material = materialClient.view(video.getMaterialId());
                            if (null != material) {
                                material.setTextHour(hour);
                                material.setTextMinute(minute);
                                material.setTextSecond(second);
                            }

                            Map<String, Object> map = new HashMap<>();
                            map.put("material", material);
                            map.put("video", video);
                            materialClient.videoUpdate(map);
                        }

                    }

                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


}
