package com.yizhi.application.customProject.contoller;

import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.file.constant.FileConstant;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.core.application.file.util.OssUpload;
import com.yizhi.custom.api.feign.ProjectActivityExperienceClient;
import com.yizhi.custom.api.vo.custom.ExperienceRulesVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author Ding
 * @className ExperienceSetExport
 * @description 经验规则下载
 * @date 2018/11/8
 **/

@Component
public class ExperienceSetExport extends AbstractDefaultTask<String, Map<String, Object>> {

    private static final Logger LOGGER = LoggerFactory.getLogger(ExperienceSetExport.class);

    @Autowired
    private ProjectActivityExperienceClient activityExperienceClient;

    @Override
    protected String execute(Map<String, Object> map) {
        String url = null;

        RequestContext res = (RequestContext) map.get("res");
        Long taskId = (Long) map.get("taskId");
        String taskName = (String) map.get("taskName");
        String serialNo = (String) map.get("serialNo");
        String poolName = (String) map.get("poolName");
        Long poolId = (Long) map.get("poolId");
        Long accountId = res.getAccountId();
        Long siteId = res.getSiteId();
        Long companyId = res.getCompanyId();
        Date submitTime = new Date();
        TaskContext taskContext = new TaskContext(taskId, serialNo, taskName, accountId, submitTime, siteId, companyId);
        working(taskContext);

        HSSFRow row = null;
        HSSFCell cell = null;
        CellRangeAddress cra = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        List<ExperienceRulesVO> resultMapList = null;
        ExperienceRulesVO experienceRulesVO = null;
        try {
            resultMapList = activityExperienceClient.getExperienceRules(poolId);
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet("经验池经验规则表");
            row = sheet.createRow(0);
            row.createCell(0).setCellValue("活动类型");
            row.createCell(1).setCellValue("活动名称");
            row.createCell(2).setCellValue("获取经验条件");
            row.createCell(3).setCellValue("获取经验值");

            if (CollectionUtils.isNotEmpty(resultMapList)) {
                for (int j = 0; j < resultMapList.size(); j++) {
                    experienceRulesVO = new ExperienceRulesVO();
                    experienceRulesVO = resultMapList.get(j);
                    row = sheet.createRow(j + 1);

                    //第一列
                    if (experienceRulesVO.getType() == 1) {
                        row.createCell(0).setCellValue("课程");
                    } else if (experienceRulesVO.getType() == 2) {
                        row.createCell(0).setCellValue("考试");
                    } else if (experienceRulesVO.getType() == 3) {
                        row.createCell(0).setCellValue("调研");
                    } else if (experienceRulesVO.getType() == 4) {
                        row.createCell(0).setCellValue("投票");
                    } else if (experienceRulesVO.getType() == 6) {
                        row.createCell(0).setCellValue("作业");
                    }

                    //第二列
                    row.createCell(1).setCellValue(experienceRulesVO.getName());

                    //第三列
                    if (experienceRulesVO.getExperienceSource() == 1) {
                        row.createCell(2).setCellValue("完成即获取");
                    } else if (experienceRulesVO.getExperienceSource() == 2) {
                        if (null != experienceRulesVO.getMaxScore()) {
                            row.createCell(2).setCellValue(experienceRulesVO.getMinScore() + "<=" + "成绩" + "<" + experienceRulesVO.getMaxScore());
                        } else {
                            row.createCell(2).setCellValue(experienceRulesVO.getMinScore() + "<=" + "成绩");
                        }
                    } else if (experienceRulesVO.getExperienceSource() == 3) {
                        row.createCell(2).setCellValue("按成绩数值获取");
                    }

                    //第四列
                    row.createCell(3).setCellValue(experienceRulesVO.getExperience());


                }
            }else {
                success(taskContext,"执行成功,未检测到数据","");
            }

            String fileName = poolName + "经验规则导出" + sdf.format(submitTime) + ".xls";
//            String requestPath = "/Users/dingxiaowei/aaa";
            String requestPath = FileConstant.SAVE_PATH;
            File fileDir = new File(requestPath);
            if (!fileDir.exists()) {
                fileDir.mkdir();
            }

            String path = requestPath + "/" + fileName;
            FileOutputStream os = null;
            File file = null;
            try {
                os = new FileOutputStream(path);
                wb.write(os);
                url = OssUpload.upload(path, fileName);//阿里云返回url
                file = new File(path);
                success(taskContext, "成功", url);
            } catch (Exception e2) {
                fail(taskContext, "下载经验规则写入过程中发生错误");
                LOGGER.error("下载经验规则写入过程中发生错误", e2);
            } finally {
                if (os != null) {
                    os.close();
                }
                if (wb != null) {
                    wb.close();
                }
                if (file != null) {
                    file.delete();
                }
            }
        } catch (Exception e) {
            LOGGER.error("下载经验规则失败", e);
            fail(taskContext, "下载经验规则失败");
        }
        return null;
    }
}
