package com.yizhi.application.customProject.contoller;


import com.yizhi.application.customProject.constant.PoolConstant;
import com.yizhi.assignment.application.feign.AssignmentClient;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.course.application.feign.RecordeClient;
import com.yizhi.custom.api.feign.ExperiencePoolProjectClient;
import com.yizhi.custom.api.feign.StudentExperienceClient;
import com.yizhi.custom.api.vo.domain.ExperiencePoolProjectVo;
import com.yizhi.exam.application.feign.ExamClient;
import com.yizhi.point.application.feign.PointActivityFeignClients;
import com.yizhi.research.application.feign.ResearchQuestionClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author Ding
 * @className PushStudentExperience
 * @description 经验池异步补发学生经验
 * @date 2019/1/16
 **/

@Component
public class PushStudentExperience extends AbstractDefaultTask<String, Map<String, Object>> {

    private static final Logger LOGGER = LoggerFactory.getLogger(PushStudentExperience.class);

    @Autowired
    private PointActivityFeignClients pointActivityClient;

    @Autowired
    private ExperiencePoolProjectClient poolProjectClient;

    @Autowired
    private StudentExperienceClient studentExperienceClient;

    @Autowired
    private RecordeClient recordeClient;

    @Autowired
    private ExamClient examClient;

    @Autowired
    private ResearchQuestionClient researchQuestionClient;

//    @Autowired
//    private VoteClient voteClient;
    
    @Autowired
    private AssignmentClient assignmentClient;

    @Override
    protected String execute(Map<String, Object> map) {
        RequestContext res = (RequestContext) map.get("res");
        String serialNo = (String) map.get("serialNo");
        Long taskId = (Long) map.get("taskId");
        String taskName = (String) map.get("taskName");
        Long experiencePoolId = (Long) map.get("experiencePoolId");
        Long companyId = res.getCompanyId();
        Long siteId = res.getSiteId();
        Long accountId = res.getAccountId();
        Date submitTime = new Date();

        TaskContext taskContext = new TaskContext(taskId, serialNo, taskName, accountId, submitTime, siteId, companyId);
        working(taskContext);

        List<ExperiencePoolProjectVo> activityList = null;

        try {
            activityList = poolProjectClient.getExperiencePoolProjectList(experiencePoolId);
            if (CollectionUtils.isEmpty(activityList)) {
                success(taskContext, "未找到关联项目", "");
            }
        } catch (Exception e) {
            LOGGER.error("经验池获取关联活动出现错误", e);
        }

        try {
            if (!CollectionUtils.isEmpty(activityList)) {
                for (ExperiencePoolProjectVo experiencePoolProject : activityList) {
                    List<Long> accountIds = null;
                    if (experiencePoolProject.getType().equals(PoolConstant.COURSETYPE)) {
                        accountIds = recordeClient.getFinishedAccountIds(experiencePoolProject.getBizId());
                    } else if (experiencePoolProject.getType().equals(PoolConstant.EXAMTYPE)) {
                        accountIds = examClient.getFinishedAccountIds(experiencePoolProject.getBizId(), companyId, siteId);
                    } else if (experiencePoolProject.getType().equals(PoolConstant.RESEARCHTYPE)) {
                        accountIds = researchQuestionClient.getFinishedAccountIds(experiencePoolProject.getBizId(), companyId, siteId);
                    } else if (experiencePoolProject.getType().equals(PoolConstant.VOTETYPE)) {
//                        accountIds = voteClient.getFinishedAccountIds(experiencePoolProject.getBizId());
                    } else if (experiencePoolProject.getType().equals(PoolConstant.ASSIGNMENTTYPE)) {
                        accountIds = assignmentClient.getFinishedAccountIds(experiencePoolProject.getBizId(),siteId,companyId);
                    }
                    
                    if (!CollectionUtils.isEmpty(accountIds)) {
                        LOGGER.info("开始补发{}的学生经验,查找出{}条,积分发放记录", experiencePoolProject.getBizName(), accountIds.size());
                        if (accountIds.size() > 10) {
                            Integer n = accountIds.size() / 10;
                            if (accountIds.size() % 10 > 0) {
                                n++;
                            }
                            for (int i = 0; i < n; i++) {
                                List<Long> ids = null;
                                if (i == n - 1) {
                                    ids = accountIds.subList(i * 10, accountIds.size());
                                } else {
                                    ids = accountIds.subList(i * 10, i * 10 + 10);
                                }
                                studentExperienceClient.pushStudentExperience(experiencePoolId, experiencePoolProject.getBizId(),
                                        experiencePoolProject.getBizName(), experiencePoolProject.getType(), ids, res);
                            }
                        } else {
                            studentExperienceClient.pushStudentExperience(experiencePoolId, experiencePoolProject.getBizId(),
                                    experiencePoolProject.getBizName(), experiencePoolProject.getType(), accountIds, res);
                        }
                        LOGGER.info("{}学生经验补发完成", experiencePoolProject.getBizName());
                    }
                }
                success(taskContext, "成功", "");
            }

        } catch (Exception e) {
            fail(taskContext, "经验池补发经验出现错误");
            LOGGER.error("经验池补发经验出现错误", e);
        }


        return "ok";
    }
}
