/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: TrExamAnswerController
 * Author:   phone
 * Date:     2018/3/29 20:11
 * Description: 答卷
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package com.yizhi.application.exam.controller;


import com.yizhi.application.exam.vo.ExamVO;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.exam.application.feign.ExamAnswerClient;
import com.yizhi.exam.application.vo.AnswerDetailVO;
import com.yizhi.exam.application.vo.AnswerQuestionDetailVO;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.enums.i18n.Constants;
import io.swagger.annotations.*;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * 〈一句话功能简述〉<br> 
 * 〈答卷〉
 *
 * @author fanchunhui
 * @create 2018/3/29 
 * @since 1.0.0
 */
@Api(tags = "管理端-答卷接口", description = "管理端-答卷接口")
@RestController
@RequestMapping("/manage/exam")
public class ExamAnswerController {

    private static final Logger LOGGER = LoggerFactory.getLogger(ExamAnswerController.class);

    @Autowired
    ExamAnswerClient examAnswerClient;

    @ApiOperation(value = "查看答卷", notes = "查看答卷",response = AnswerDetailVO.class)
    @GetMapping("/count/account/answer")
    public Response<AnswerDetailVO> getAnswer(
            @ApiParam(name = "examId", value = "考试的id") @RequestParam(name = "examId", required = true) Long examId,
            @ApiParam(name = "examNum", value = "第几次考试") @RequestParam(name = "examNum", required = false,defaultValue = "1") Integer examNum,
            @ApiParam(name = "pageNo", value = "当前页") @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo,
            @ApiParam(name = "pageSize", value = "每页的个数") @RequestParam(name = "pageSize", required = false, defaultValue = "20") Integer pageSize
    ) {
        AnswerDetailVO answerDetailVO = null;
        try {
            answerDetailVO= examAnswerClient.getAnswer(examId, examNum, pageNo, pageSize, ContextHolder.get().getAccountId());
            return Response.ok(answerDetailVO);
        } catch (Exception e) {
            LOGGER.error("", e);
            e.printStackTrace();
            return Response.fail(Constants.MSG_BIZ_FAIL.getCode().toString(),Constants.MSG_BIZ_FAIL.getName());
        }
    }

    @ApiOperation(value = "导出考试结果", notes = "导出考试结果")
    @ApiImplicitParams(
            @ApiImplicitParam(name = "examId",value = "考试ID",paramType = "body")
    )
    @PostMapping("/export/result")
    public Response<String> getExamAnswer(HttpServletResponse response,
                                 @RequestBody ExamVO examVO
    ) {
        Boolean b = false;
        try {
            b = examAnswerClient.getExamAnswer(response,examVO.getExamId());
            return Response.ok(b);
        } catch (Exception e) {
            LOGGER.error("", e);
            e.printStackTrace();
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(), ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "答卷详情", notes = "答卷详情",response = AnswerQuestionDetailVO.class)
    @GetMapping("result/details")
    public Response<AnswerQuestionDetailVO> answerQuestionDetail(
            @ApiParam(name = "answerId",value = "答卷id")@RequestParam(name = "answerId",required = true
            ) Long answerId,
            @ApiParam(value = "每页条数，默认10", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
            @ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo
    ) {
        List<AnswerQuestionDetailVO> list = null;
        Map<String,Integer> page = null;
        //答卷详情，分页查询
       try {
           Map<String,Object> map = examAnswerClient.answerQuestionDetail(answerId, pageNo, pageSize);
           if (null != map.get("list")){
               list = (List<AnswerQuestionDetailVO>) map.get("list");
           }
           if (null != map.get("page")){
               page = (Map<String, Integer>) map.get("page");
           }
           Pair<List<AnswerQuestionDetailVO>,Map<String,Integer>> pair = new MutablePair<List<AnswerQuestionDetailVO>,Map<String,Integer>>(list,page);
           return Response.ok(pair);
       }catch (Exception e){
           LOGGER.error("", e);
           e.printStackTrace();
           return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
       }
    }

}