package com.yizhi.application.exam.controller;


import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.exam.application.feign.QuestionLibraryClient;
import com.yizhi.exam.application.vo.QuestionLibraryVO;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;


@Api(tags = "管理端—导出接口", description = "管理端-导出接口")
@RestController
@RequestMapping("/manage/exam")
public class ExamExportController {
    @Autowired
    private LibrarySubjectExport li;
    @Autowired
    private LibrarySubjectXmlExport lxml;
    @Autowired
    QuestionLibraryClient questionLibraryClient;

    @Value("${pc.host.url}")
    String pcHostUrl;
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");

    @ApiOperation("题库试题导出")
    @GetMapping("/question/subject/export")
    public Response<String> exportQuestionSubject(@ApiParam(name = "libraryId", value = "题库Id") @RequestParam Long libraryId,
                                                  @ApiParam(name = "subjectNum", value = "题数") @RequestParam(name = "subjectNum", required = false) Integer subjectNum,
                                                  @ApiParam(name = "pageNo", value = "pageNo")
                                                  @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo,
                                                  @ApiParam(name = "pageSize", value = "pageSize")
                                                  @RequestParam(name = "pageSize", required = false, defaultValue = "20") Integer pageSize) {
        RequestContext requestContext = ContextHolder.get();
        Long accountId = requestContext.getAccountId();
        Long siteId = requestContext.getSiteId();
        Long companyId = requestContext.getCompanyId();
        Long orgId = requestContext.getOrgId();
        Long taskId = System.currentTimeMillis();

        Map<String, Object> map = new HashMap();
        map.put("subjectNum", subjectNum);
        map.put("accountId", accountId);
        map.put("companyId", companyId);
        map.put("siteId", siteId);
        map.put("orgId", orgId);
        map.put("libraryId", libraryId);
        map.put("taskId", taskId);
        if (pageNo > 0 && pageSize > 0) {
            map.put("pageNo", pageNo);
            map.put("pageSize", pageSize);
        }
        li.execute(map, true);
        String libraryName = questionLibraryClient.selectQuestionLibraryById(libraryId).getName();
        StringBuffer fileName = new StringBuffer().append(libraryName).append("--").append(taskId).append(".xls");
        String fileUril = pcHostUrl+"/api/v1/buckets/upload/objects/download/?preview=true&prefix="+fileName.toString();
        return Response.ok(fileUril);
    }

    @ApiOperation("题库试题导出_xml")
    @GetMapping("/question/subject/exportXml")
    public Response<String> exportXmlQuestionSubject(@ApiParam(name = "libraryId", value = "题库Id") @RequestParam Long libraryId,
                                                     @ApiParam(name = "subjectNum", value = "题数") @RequestParam(name = "subjectNum", required = false) Integer subjectNum,
                                                     @ApiParam(name = "pageNo", value = "pageNo")
                                                     @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo,
                                                     @ApiParam(name = "pageSize", value = "pageSize")
                                                     @RequestParam(name = "pageSize", required = false, defaultValue = "20") Integer pageSize) {
        RequestContext requestContext = ContextHolder.get();
        Long accountId = requestContext.getAccountId();
        Long siteId = requestContext.getSiteId();
        Long companyId = requestContext.getCompanyId();
        Long orgId = requestContext.getOrgId();

        Date submitTime = new Date();
        Long taskId = submitTime.getTime();
        String serialNo = "" + taskId;
        String taskName = "题库试题导出-" + taskId;

        Map<String, Object> map = new HashMap();
        map.put("accountId", accountId);
        map.put("companyId", companyId);
        map.put("siteId", siteId);
        map.put("orgId", orgId);
        map.put("libraryId", libraryId);
        map.put("subjectNum", subjectNum);

        map.put("serialNo", serialNo);
        map.put("taskId", taskId);
        map.put("submitTime", submitTime);
        map.put("taskName", taskName);
        map.put("pageNo", pageNo);
        map.put("pageSize", pageSize);
        lxml.execute(map, true);
        QuestionLibraryVO questionLibraryVO = questionLibraryClient.selectQuestionLibraryById(libraryId);
        String sheetName = questionLibraryVO.getName();
        String fileName = sheetName + "_" + simpleDateFormat.format(submitTime) + ".xml";
        String fileUril = pcHostUrl+"/api/v1/buckets/upload/objects/download/?preview=true&prefix="+fileName;
        return Response.ok(fileUril);
    }

}
