package com.yizhi.application.lecturer.Controller;


import com.yizhi.lecturer.application.feign.LecturerClassificationClient;
import com.yizhi.lecturer.application.vo.LecturerClassificationVO;
import com.yizhi.lecturer.application.vo.LecturerGradeVO;
import com.yizhi.lecturer.application.vo.domain.LecturerGradeVo;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.enums.i18n.Constants;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.log4j.Log4j2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @description: 讲师库字典
 * @author: lly
 * @date: 2019-04-18 11:50
 **/
@Log4j2
@Api(tags = "讲师库级别")
@RestController
@RequestMapping("/manage/lecturer/grade")
public class LecturerGradeController {

    private static final Logger LOG = LoggerFactory.getLogger(LecturerGradeController.class);

    @Autowired
    private LecturerClassificationClient classificationClient;

    /**
     * 分类列表
     *
     * @param status
     * @return
     */
    @ApiOperation(value = "获取级别列表", notes = "获取级别列表", response = LecturerGradeVo.class)
    @GetMapping(value = "/list")
    public Response<LecturerGradeVo> get(@ApiParam(name = "status", value = "参数不传则是全部；0下架，1上架") @RequestParam(name = "status", required = false) Integer status) {
        List<LecturerGradeVo> list = classificationClient.list(status);
        return Response.ok(list);
    }

    /**
     * 分类新增
     *
     * @param lecturerGradeVO
     * @return
     */
    @ApiOperation(value = "级别新增", notes = "级别新增", response = LecturerGradeVO.class)
    @PostMapping(value = "/add")
    public Response<LecturerClassificationVO> add(@RequestBody LecturerGradeVO lecturerGradeVO) {
        LecturerGradeVO vo = null;
        try {
            vo = classificationClient.add(lecturerGradeVO);
            return Response.ok(vo);
        } catch (Exception e) {
            return Response.fail(Constants.LECTURER_MSG_BIZ_ERROR);
        }
    }

    /**
     * 讲师级别修改
     *
     * @param lecturerGradeVO
     * @return
     */
    @ApiOperation(value = "级别修改/删除/上下架", notes = "级别修改/删除/上下架", response = LecturerGradeVO.class)
    @PostMapping(value = "/update")
    public Response<LecturerClassificationVO> update(@RequestBody LecturerGradeVO lecturerGradeVO) {
        LecturerGradeVO vo = null;
        try {
            vo = classificationClient.update(lecturerGradeVO);
            return Response.ok(vo);
        } catch (Exception e) {
            return Response.fail(Constants.LECTURER_MSG_BIZ_ERROR);
        }

    }

}