package com.yizhi.application.rangeImport;

import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.exam.application.feign.ExamAuthorizeClient;
import com.yizhi.exam.application.vo.domain.TrExamAuthorize;
import com.yizhi.system.application.model.AccountRangeImportModel;
import com.yizhi.system.application.model.AccountRangeImportParam;
import com.yizhi.system.application.system.remote.AccountRangeClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @Auther: dingxiaowei
 * @Date: 2018/9/17 16:36
 * @Description:考试可见范围异步导入
 */
public
@Component
class ExamRangeImport extends AbstractDefaultTask<String, Map<String, Object>> {

    private static final Logger LOGGER = LoggerFactory.getLogger(ExamRangeImport.class);

    @Autowired
    private AccountRangeClient accountRangeClient;

    @Autowired
    private ExamAuthorizeClient examAuthorizeClient;
    @Autowired
    private RangeUtil importUtil;

    @Override
    protected String execute(Map<String, Object> map) {
        //从map中取值
        String ossUrl = (String) map.get("ossUrl");
        RequestContext res = (RequestContext) map.get("requestContext");
        Long examId = (Long) map.get("examId");
        Long accountId = res.getAccountId();
        Long siteId = res.getSiteId();
        String accountFullName = res.getAccountFullName();
        Long companyId = res.getCompanyId();
        Date submitTime = new Date();
        Long taskId = (Long) map.get("taskId");
        String serialNo = (String) map.get("serialNo");
        String taskName = (String) map.get("taskName");
        TaskContext taskContext = new TaskContext(taskId, serialNo, taskName, accountId, submitTime, siteId, companyId);
        working(taskContext);

        //将请求值装入param
        AccountRangeImportParam param = new AccountRangeImportParam();
        param.setType(AccountRangeImportParam.Type.EXAM);
        param.setOssUrl(ossUrl);
        param.setRequestContext(res);
        List<AccountRangeImportModel.SuccessAccount> successList = null;
        List<AccountRangeImportModel.ErrorAccount> errorList = null;
        List<Integer> integerList = null;
        //进行入库
        try {
            AccountRangeImportModel accountRangeImportModel = accountRangeClient.doImport(param);
            if (null != accountRangeImportModel) {
                successList = accountRangeImportModel.getSuccessList();
                errorList = accountRangeImportModel.getErrorList();
            }
            errorList = (errorList == null ? new ArrayList<>() : errorList);
            successList = (successList == null ? new ArrayList<>() : successList);

            List<TrExamAuthorize> trExamAuthorizes = new ArrayList<>();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Timestamp createTime = Timestamp.valueOf(sdf.format(new Date()));

            TrExamAuthorize trExamAuthorize = null;
            if (!CollectionUtils.isEmpty(successList)) {
                for (AccountRangeImportModel.SuccessAccount rangeImportModel : successList) {
                    trExamAuthorize = new TrExamAuthorize();
                    trExamAuthorize.setState(1);
                    trExamAuthorize.setType(2);
                    trExamAuthorize.setRelationId(rangeImportModel.getId());
                    trExamAuthorize.setName(rangeImportModel.getName());
                    trExamAuthorize.setExamId(examId);
                    trExamAuthorize.setCreateById(accountId);
                    trExamAuthorize.setCreateByName(accountFullName);
                    trExamAuthorize.setCreateTime(createTime);
                    trExamAuthorize.setSiteId(siteId);
                    trExamAuthorizes.add(trExamAuthorize);
                }
                examAuthorizeClient.insertTrExamAuthorizes(trExamAuthorizes);
            }

            importUtil.returnResults(taskContext, successList, errorList, ossUrl);
        } catch (Exception e) {
            e.printStackTrace();
            fail(taskContext, "考试可见范围异步导入过程中出现错误");
            LOGGER.error("考试可见范围异步导入过程中出现错误", e);
        }

        return "ok";
    }


}
