package com.yizhi.application.rangeImport;

import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.research.application.feign.ResearchAuthorizeClient;
import com.yizhi.research.application.vo.domain.TrResearchAuthorizeVo;
import com.yizhi.system.application.model.AccountRangeImportModel;
import com.yizhi.system.application.model.AccountRangeImportParam;
import com.yizhi.system.application.system.remote.AccountRangeClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @Auther: dingxiaowei
 * @Date: 2018/9/17 16:39
 * @Description:调研可见范围异步导入
 */
@Component
public class ResearchRangeImport extends AbstractDefaultTask<String, Map<String, Object>> {

    private static final Logger LOGGER = LoggerFactory.getLogger(ResearchRangeImport.class);

    @Autowired
    private AccountRangeClient accountRangeClient;

    @Autowired
    private ResearchAuthorizeClient researchAuthorizeClient;

    @Autowired
    private RangeUtil importUtil;

    @Override
    protected String execute(Map<String, Object> map) {

        //从map中取值
        String ossUrl = (String) map.get("ossUrl");
        RequestContext res = (RequestContext) map.get("requestContext");
        Long researchId = (Long) map.get("researchId");
        Long accountId = res.getAccountId();
        Long siteId = res.getSiteId();
        String accountFullName = res.getAccountFullName();
        Long companyId = res.getCompanyId();
        Date submitTime = new Date();
        Long taskId = (Long) map.get("taskId");
        String serialNo = (String) map.get("serialNo");
        String taskName = (String) map.get("taskName");
        TaskContext taskContext = new TaskContext(taskId, serialNo, taskName, accountId, submitTime, siteId, companyId);
        working(taskContext);
        //将请求值装入param
        AccountRangeImportParam param = new AccountRangeImportParam();
        param.setType(AccountRangeImportParam.Type.RESEARCH);
        param.setOssUrl(ossUrl);
        param.setRequestContext(res);
        List<AccountRangeImportModel.SuccessAccount> successList = null;
        List<AccountRangeImportModel.ErrorAccount> errorList = null;
        List<Integer> integerList = null;
        //进行入库
        try {
            AccountRangeImportModel accountRangeImportModel = accountRangeClient.doImport(param);
            if (null != accountRangeImportModel) {
                successList = accountRangeImportModel.getSuccessList();
                errorList = accountRangeImportModel.getErrorList();
            }

            errorList = (errorList == null ? new ArrayList<>() : errorList);
            successList = (successList == null ? new ArrayList<>() : successList);

            List<TrResearchAuthorizeVo> trResearchAuthorizes = new ArrayList<>();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Timestamp createTime = Timestamp.valueOf(sdf.format(new Date()));

            TrResearchAuthorizeVo trResearchAuthorize = null;
            if (!CollectionUtils.isEmpty(successList)) {
                for (AccountRangeImportModel.SuccessAccount rangeImportModel : successList) {
                    trResearchAuthorize = new TrResearchAuthorizeVo();
                    trResearchAuthorize.setState(1);
                    trResearchAuthorize.setType(2);
                    trResearchAuthorize.setRelationId(rangeImportModel.getId());
                    trResearchAuthorize.setName(rangeImportModel.getName());
                    trResearchAuthorize.setResearchId(researchId);
                    trResearchAuthorize.setCreateById(accountId);
                    trResearchAuthorize.setCreateByName(accountFullName);
                    trResearchAuthorize.setCreateTime(createTime);
                    trResearchAuthorize.setSiteId(siteId);
                    trResearchAuthorizes.add(trResearchAuthorize);

                }
                researchAuthorizeClient.insertResearchAuthorize(trResearchAuthorizes);
            }


            importUtil.returnResults(taskContext, successList, errorList, ossUrl);

        } catch (Exception e) {
            e.printStackTrace();
            fail(taskContext, "调研可见范围异步导入过程中出现错误");
            LOGGER.error("调研可见范围异步导入过程中出现错误", e);
        }

        return "ok";
    }
}
