package com.yizhi.application.report.exam;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.exam.application.feign.ExamAuthorizeClient;
import com.yizhi.exam.application.feign.ExamReportClient;
import com.yizhi.exam.application.feign.StatisticsExamMetadataClient;
import com.yizhi.exam.application.vo.report.ReportExamChartsVo;
import com.yizhi.exam.application.vo.report.ReportExamSubjectChartsVotr;
import com.yizhi.statistics.application.exam.domain.po.ExamGroupPO;
import com.yizhi.statistics.application.exam.domain.po.UserExamGroupPO;
import com.yizhi.statistics.application.exam.domain.vo.ExamGroupOrgVO;
import com.yizhi.statistics.application.exam.domain.vo.UserExamByOrgVO;
import com.yizhi.statistics.application.feign.StatisticsExamClient;
import com.yizhi.statistics.application.refactor.exam.*;
import com.yizhi.system.application.system.remote.AccountClient;
import com.yizhi.system.application.system.remote.OrganizationClient;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.enums.i18n.Constants;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 考试报表统计
 *
 * @author mei
 */

@Api(tags = "报表统计-考试统计", description = "报表统计-考试统计")
@RestController
@RequestMapping("/manage/report/exam/")
public class ReportExamController {


    private static Logger logger = LoggerFactory.getLogger(ReportExamController.class);

    @Autowired
    ExamReportClient examReportClient;

    @Autowired
    OrganizationClient organizationClient;

    @Autowired
    AccountClient accountClient;

    @Autowired
    ExamAuthorizeClient examAuthorizeClient;

    @Autowired
    ExamGroupExport examGroupExport;

    @Autowired
    AccountGroupExport accountGroupExport;

    @Autowired
    AccountGroupViewExport accountGroupViewExport;

    @Autowired
    ExamAccountTrExamsExport examAccountTrExamsExport;

    @Autowired
    ExamAccountTrExamsViewExport examAccountTrExamsViewExport;

    @Autowired
    StatisticsExamMetadataClient statisticsExamMetadataClient;

    @Autowired
    private StatisticsExamClient statisticsExamClient;

    @GetMapping("/group/org")
    @ApiOperation(value = "考试按部门统计", response = ExamGroupOrgVO.class)
    public Response<Page<ExamGroupOrgVO>> getExamGroupByOrg(
            @RequestParam(value = "orgNameOrCode",required = false) String orgNameOrCode,
            @RequestParam("pageSize") Integer pageSize,
            @RequestParam("pageIndex") Integer pageIndex,
            @RequestParam("startAt") String startAt,
            @RequestParam("endAt") String endAt) {

        ExamGroupPO po =  new ExamGroupPO();
        po.setOrgNameLike(orgNameOrCode.trim());
        po.setPageSize(pageSize);
        po.setPageIndex(pageIndex);
        po.setStartAt(startAt);
        po.setEndAt(endAt);
        RequestContext req = ContextHolder.get();

        po.setCompanyId(req.getCompanyId());
        po.setSiteId(req.getSiteId());
        po.setOrgId(req.getOrgId());
        po.setAccountId(req.getAccountId());
        Page page = statisticsExamClient.getExamGroupByOrg(po);
        return Response.ok(page);
    }

    @GetMapping("/group/org/download")
    @ApiOperation(value = "考试按部门统计下载", response = ExamGroupOrgVO.class)
    public Response<String> getExamGroupByOrgExport(
            @RequestParam(value = "orgNameOrCode",required = false) String orgNameOrCode,
            @RequestParam("startAt") String startAt,
            @RequestParam("endAt") String endAt) {
        ExamGroupPO po =  new ExamGroupPO();
        po.setOrgNameLike(orgNameOrCode.trim());
        po.setStartAt(startAt);
        po.setEndAt(endAt);
        RequestContext req = ContextHolder.get();

        po.setCompanyId(req.getCompanyId());
        po.setSiteId(req.getSiteId());
        po.setOrgId(req.getOrgId());
        po.setAccountId(req.getAccountId());
        String msg  = statisticsExamClient.getExamGroupByOrgDownload(po);
        return Response.ok(msg);
    }

    @GetMapping("/group/org/users")
    @ApiOperation(value = "部门下用户的考试成绩",response = UserExamByOrgVO.class)
    public Response<Page<UserExamByOrgVO>> getExamByGroupOrgUser(
            @RequestParam(value = "orgCode",required = false) String orgCode,
            @RequestParam("orgId") Long orgId,
            @RequestParam(value = "userName",required = false) String userName,
            @RequestParam(value = "pageSize",required = false,defaultValue = "1") Integer pageSize,
            @RequestParam(value = "pageIndex",required = false,defaultValue = "10") Integer pageIndex,
            @RequestParam(value = "startAt",required = false) String startAt,
            @RequestParam(value = "endAt",required = false) String endAt
    ) {
        UserExamGroupPO po = new UserExamGroupPO();
        po.setOrgId(orgId);
        po.setUserName(userName);
        po.setPageIndex(pageIndex);
        po.setPageSize(pageSize);
        po.setStartAt(startAt);
        po.setEndAt(endAt);
        po.setOrgCode(orgCode);
        Page<UserExamByOrgVO> page = statisticsExamClient.getExamByGroupOrgUser(po);
        return Response.ok(page);
    }

    @GetMapping("/group/org/users/download")
    @ApiOperation(value = "部门下用户的考试成绩下载")
    public Response<String> getExamByGroupOrgUserDownload(
            @RequestParam("orgCode") String orgCode,
            @RequestParam("orgId") Long orgId,
            @RequestParam(value = "userName",required = false) String userName,
            @RequestParam(value = "startAt",required = false) String startAt,
            @RequestParam(value = "endAt",required = false) String endAt
    ) {
        UserExamGroupPO po = new UserExamGroupPO();
        po.setOrgCode(orgCode);
        po.setOrgId(orgId);
        po.setUserName(userName);
        po.setStartAt(startAt);
        po.setEndAt(endAt);
        String msg = statisticsExamClient.getExamByGroupOrgUserDownload(po);
        return Response.ok(msg);
    }

    @GetMapping("/group/org/users/detail/download")
    @ApiOperation(value = "部门下用户的考试明细下载")
    public Response<String> getExamByGroupOrgUserDetailDownload(
            @RequestParam("orgCode") String orgCode,
            @RequestParam("orgId") Long orgId,
            @RequestParam(value = "userName",required = false) String userName,
            @RequestParam(value = "startAt",required = false) String startAt,
            @RequestParam(value = "endAt",required = false) String endAt
    ) {
        UserExamGroupPO po = new UserExamGroupPO();
        po.setOrgCode(orgCode);
        po.setOrgId(orgId);
        po.setUserName(userName);
        po.setStartAt(startAt);
        po.setEndAt(endAt);
        String msg = statisticsExamClient.getExamByGroupOrgUserDetailDownload(po);
        return Response.ok(msg);
    }

    @ApiOperation(value = "考试答卷下载", notes = "考试答卷下载")
    @GetMapping("/answer/student/export")
    public Response<Object> downStudentExamAnswer(
            @ApiParam(value = "开始时间", required = false) @RequestParam(name = "startTime", required = false) String startTime,
            @ApiParam(value = "结束时间", required = false) @RequestParam(name = "endTime", required = false) String endTime,
            @ApiParam(value = "考试ID", required = true) @RequestParam(name = "examId", required = true) Long examId,
            @ApiParam(value = "考试名称", required = true) @RequestParam(name = "examName", required = true) String examName,
            @ApiParam(value = "部门关键字", required = false) @RequestParam(name = "orgNameLike", required = false) String orgNameLike,
            @ApiParam(value = "用户关键字", required = false) @RequestParam(name = "accountNameLike", required = false) String accountNameLike) {
        RequestContext requestContext = ContextHolder.get();
        if (null == requestContext) {
            Response.fail();
        }
        Date date = new Date();
        Long taskId = date.getTime();
        String serialNo = "ANSWER-STUDENT-EXPORT-" + taskId.toString();
        String taskName = "按考试统计-查看-考试答卷导出-" + taskId.toString();
        Long companyId = requestContext.getCompanyId();
        Long siteId = requestContext.getSiteId();
        Long accountId = requestContext.getAccountId();
        List<Long> orgIds = null;
        Map<String, Object> paramMaps = new HashMap<String, Object>();
        if (!requestContext.isAdmin()) {
            orgIds = requestContext.getOrgIds();
            paramMaps.put("orgIds", orgIds);
        }
        paramMaps.put("taskId", taskId);
        paramMaps.put("serialNo", serialNo);
        paramMaps.put("taskName", taskName);
        paramMaps.put("startTime", startTime);
        paramMaps.put("endTime", endTime);
        paramMaps.put("orgNameLike", orgNameLike);
        paramMaps.put("accountNameLike", accountNameLike);
        paramMaps.put("accountId", accountId);
        paramMaps.put("examId", examId);
        paramMaps.put("examName", examName);
        paramMaps.put("companyId", companyId);
        paramMaps.put("siteId", siteId);
        examReportClient.downStudentExamAnswer(paramMaps);

        return Response.ok("导出成功," + " " + "编号:" + taskName);
    }

    /**
     * 从考试服务迁到报表服务
     *
     * @param startTime
     * @param endTime
     * @param examNameLike
     * @param pageSize
     * @param pageNo
     * @return
     */
    @ApiOperation(value = "按考试统计", notes = "按考试统计", response = ReportExamVO.class)
    @GetMapping("/group")
    public Response<ReportExamVO> getExamGroup(
            @ApiParam(value = "开始时间", required = false) @RequestParam(name = "startDate", required = false) String startTime,
            @ApiParam(value = "结束时间", required = false) @RequestParam(name = "endDate", required = false) String endTime,
            @ApiParam(value = "考试名称", required = false) @RequestParam(name = "examNameLike", required = false) String examNameLike,
            @ApiParam(value = "每页条数，默认10", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "20") Integer pageSize,
            @ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo) {

        ReportExamParam reportExamParam = new ReportExamParam();
        reportExamParam.setPageNo(pageNo);
        reportExamParam.setPageSize(pageSize);
        if (StringUtils.isNotBlank(examNameLike)) {
            reportExamParam.setExamNameLike(examNameLike.trim());
        }
        reportExamParam.setStartTime(startTime);
        reportExamParam.setEndTime(endTime);

        RequestContext requestContext = ContextHolder.get();
        Long companyId = requestContext.getCompanyId();
        Long siteId = requestContext.getSiteId();
        List<Long> orgIds = requestContext.getOrgIds();
        reportExamParam.setSiteId(siteId);
        reportExamParam.setCompanyId(companyId);
        reportExamParam.setOrgIds(orgIds);

        try {
            Page<ReportExamVO> page = statisticsExamClient.getExamGroup(reportExamParam);
            return Response.ok(page);
        } catch (Exception e) {
            logger.info("按考试统计查看数据出现错误", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }

    }

    /**
     * 从考试服务迁到报表服务
     *
     * @param startTime
     * @param endTime
     * @param examNameLike
     * @return
     */
    @ApiOperation(value = "按考试统计结果下载", notes = "按考试统计下载")
    @GetMapping("/group/download")
    public Response<String> getExamGroupDownload(
            @ApiParam(value = "开始时间", required = false) @RequestParam(name = "startDate", required = false) String startTime,
            @ApiParam(value = "结束时间", required = false) @RequestParam(name = "endDate", required = false) String endTime,
            @ApiParam(value = "考试名称", required = false) @RequestParam(name = "examNameLike", required = false) String examNameLike) {
        ReportExamParam reportExamParam = new ReportExamParam();
        reportExamParam.setStartTime(startTime);
        reportExamParam.setEndTime(endTime);
        if (StringUtils.isNotBlank(examNameLike)) {
            reportExamParam.setExamNameLike(examNameLike.trim());
        }
        try {
            String serialNo = statisticsExamClient.getExamGroupDownload(reportExamParam);
            return Response.ok("导出成功," + " " + "编号:" + serialNo);
        } catch (Exception e) {
            e.printStackTrace();
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }


    @ApiOperation(value = "按考试统计-查看（按分数段统计）", notes = "按考试统计-查看（按分数段统计）", response = ReportExamChartsVo.class)
    @GetMapping("/score/group/view")
    public Response<ReportExamChartsVo> getExamScoreGroupView(
            @ApiParam(value = "考试ID", required = true) @RequestParam(name = "examId", required = true) Long examId,
            @ApiParam(value = "开始时间", required = false) @RequestParam(name = "startTime", required = false) String startTime,
            @ApiParam(value = "结束时间", required = false) @RequestParam(name = "endTime", required = false) String endTime) {
        List<ReportExamChartsVo> chars = examReportClient.getExamScoreGroupView(examId, startTime, endTime);
        return Response.ok(chars);
    }

    /**
     * 从考试服务迁到报表服务
     *
     * @param startTime
     * @param endTime
     * @param examId
     * @param orgNameLike
     * @param accountNameLike
     * @param joinState
     * @param pageSize
     * @param pageNo
     * @return
     */
    @ApiOperation(value = "按考试统计-查看 (按用户统计)", notes = "按考试统计-查看 (按用户统计)", response = ReportExamAccountsViewVo.class)
    @GetMapping("/group/account")
    public Response<ReportExamAccountsViewVo> getExamAccountView(
            @ApiParam(value = "开始时间", required = false) @RequestParam(name = "startTime", required = false) String startTime,
            @ApiParam(value = "结束时间", required = false) @RequestParam(name = "endTime", required = false) String endTime,
            @ApiParam(value = "考试Id", required = true) @RequestParam(name = "examId", required = true) Long examId,
            @ApiParam(value = "部门编码或部门名称", required = false) @RequestParam(name = "orgNameLike", required = false) String orgNameLike,
            @ApiParam(value = "用户关键字", required = false) @RequestParam(name = "accountNameLike", required = false) String accountNameLike,
            @ApiParam(value = "参加状态", required = false) @RequestParam(name = "joinState", required = false) Integer joinState,
            @ApiParam(value = "每页条数，默认20", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "20") Integer pageSize,
            @ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo) {

        ExamCountByUserVO vo = new ExamCountByUserVO();
        vo.setStartTime(startTime);
        vo.setEndTime(endTime);
        vo.setExamId(examId);
        if (StringUtils.isNotBlank(orgNameLike)) {
            vo.setOrgNameLike(orgNameLike.trim());
        }
        if (StringUtils.isNotBlank(accountNameLike)) {
            vo.setAccountNameLike(accountNameLike.trim());
        }
        vo.setJoinState(joinState);
        vo.setPageNo(pageNo);
        vo.setPageSize(pageSize);
        RequestContext requestContext = ContextHolder.get();
        Long companyId = requestContext.getCompanyId();
        vo.setCompanyId(companyId);
        vo.setSiteId(requestContext.getSiteId());
        vo.setOrgIds(requestContext.getOrgIds());
        vo.setAccountId(requestContext.getAccountId());
        vo.setAdmin(requestContext.isAdmin());
        try {
            return Response.ok(statisticsExamClient.getExamAccountView(vo));
        } catch (Exception e) {
            logger.info("获取数据出现错误", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    /**
     * 从考试服务迁到报表服务
     *
     * @param startTime
     * @param endTime
     * @param examId
     * @param orgNameLike
     * @param accountNameLike
     * @param joinState
     * @return
     */
    @ApiOperation(value = "按考试统计-查看 (按用户统计)下载考试结果数据",
            notes = "按考试统计-查看 (按用户统计)下载考试结果数据", response = ReportExamAccountsViewVo.class)
    @GetMapping("/group/account/trExams/download")
    public Response<String> getExamAccountTrExamsDownload(
            @ApiParam(value = "开始时间", required = false) @RequestParam(name = "startTime", required = false) String startTime,
            @ApiParam(value = "结束时间", required = false) @RequestParam(name = "endTime", required = false) String endTime,
            @ApiParam(value = "考试Id", required = true) @RequestParam(name = "examId", required = true) Long examId,
            @ApiParam(value = "部门编码或部门名称", required = false) @RequestParam(name = "orgNameLike", required = false) String orgNameLike,
            @ApiParam(value = "用户关键字", required = false) @RequestParam(name = "accountNameLike", required = false) String accountNameLike,
            @ApiParam(value = "参加状态", required = true) @RequestParam(name = "joinState", required = false) Integer joinState) {

        ExamCountByUserVO vo = new ExamCountByUserVO();
        vo.setStartTime(startTime);
        vo.setEndTime(endTime);
        vo.setExamId(examId);
        if (StringUtils.isNotBlank(orgNameLike)) {
            vo.setOrgNameLike(orgNameLike.trim());
        }
        if (StringUtils.isNotBlank(accountNameLike)) {
            vo.setAccountNameLike(accountNameLike.trim());
        }
        vo.setJoinState(joinState);
        try {
            String serialNo = statisticsExamClient.getExamAccountTrExamsDownload(vo);
            return Response.ok("导出成功," + " " + "编号:" + serialNo);
        } catch (Exception e) {
            e.printStackTrace();
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }


    @ApiOperation(value = "按考试统计-查看 (按用户统计)下载考试明细", notes = "按考试统计-查看 (按用户统计)下载考试明细", response = ReportExamAccountsViewVo.class)
    @GetMapping("/group/account/trExams/view/download")
    public Response<String> getExamAccountTrExamsViewDownload(
            @ApiParam(value = "考试id", required = true) @RequestParam(value = "examId", required = true) Long examId,
            @ApiParam(value = "用户关键字", required = false) @RequestParam(value = "accountNameLike", required = false) String accountNameLike,
            @ApiParam(value = "部门关键字", required = false) @RequestParam(value = "orgNameLike", required = false) String orgNameLike,
            @ApiParam(value = "开始时间", required = false) @RequestParam(value = "startTime", required = false) String startTime,
            @ApiParam(value = "结束时间", required = false) @RequestParam(value = "endTime", required = false) String endTime) {
        Date date = new Date();
        Long taskId = date.getTime();
        String serialNo = "EXAMGROUP-ACCOUNT-TREXAMS-EXPORT-" + taskId.toString();
        String taskName = "按考试统计-查看-按用户统计-下载考试明细-" + taskId.toString();
        Map<String, Object> map = new HashMap<>();
        map.put("taskId", taskId);
        map.put("serialNo", serialNo);
        map.put("taskName", taskName);
        map.put("examId", examId);
        map.put("accountNameLike", accountNameLike);
        map.put("orgNameLike", orgNameLike);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        map.put("accountId", ContextHolder.get().getAccountId());
        map.put("siteId", ContextHolder.get().getSiteId());
        map.put("companyId", ContextHolder.get().getCompanyId());
        map.put("isAdmin", ContextHolder.get().isAdmin());
        examAccountTrExamsViewExport.execute(map, true);
        return Response.ok("导出成功," + " " + "编号:" + serialNo);
    }

    @ApiOperation(value = "按考试统计-查看（按考题统计）", notes = "按考试统计-查看（按考题统计）", response = ReportExamSubjectChartsVotr.class)
    @GetMapping("/sub/group/view")
    public Response<ReportExamSubjectChartsVotr> getExamSubGroupView(
            @ApiParam(value = "考试ID", required = true) @RequestParam(name = "examId", required = true) Long examId,
            @ApiParam(value = "开始时间", required = false) @RequestParam(name = "startTime", required = false) String startTime,
            @ApiParam(value = "结束时间", required = false) @RequestParam(name = "endTime", required = false) String endTime) {
        List<ReportExamSubjectChartsVotr> list = examReportClient.getExamSubGroupView(examId, startTime, endTime);
        return Response.ok(list);
    }

    /**
     * 从考试服务迁到报表服务
     *
     * @param startTime
     * @param endTime
     * @param orgNameLike
     * @param accountNameLike
     * @param pageSize
     * @param pageNo
     * @return
     */
    @ApiOperation(value = "按用户统计", notes = "按用户统计", response = ReportExamAccountVO.class)
    @GetMapping("/account/group")
    public Response<ReportExamAccountVO> getAccountGroup(
            @ApiParam(value = "开始时间", required = false) @RequestParam(name = "startTime", required = false) String startTime,
            @ApiParam(value = "结束时间", required = false) @RequestParam(name = "endTime", required = false) String endTime,
            @ApiParam(value = "部门编码或部门名称", required = false) @RequestParam(name = "orgNameLike", required = false) String orgNameLike,
            @ApiParam(value = "用户关键字", required = false) @RequestParam(name = "accountNameLike", required = false) String accountNameLike,
            @ApiParam(value = "每页条数，默认20", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "20") Integer pageSize,
            @ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo) {
        ExamCountByUserVO vo = new ExamCountByUserVO();
        vo.setStartTime(startTime);
        vo.setEndTime(endTime);
        if (StringUtils.isNotBlank(orgNameLike)) {
            vo.setOrgNameLike(orgNameLike.trim());
        }
        if (StringUtils.isNotBlank(accountNameLike)) {
            vo.setAccountNameLike(accountNameLike.trim());
        }
        vo.setPageNo(pageNo);
        vo.setPageSize(pageSize);

        RequestContext requestContext = ContextHolder.get();
        vo.setOrgIds(requestContext.getOrgIds());
        vo.setSiteId(requestContext.getSiteId());
        vo.setCompanyId(requestContext.getCompanyId());
        try {
            Page<ReportExamAccountVO> page = statisticsExamClient.getAccountGroup(vo);
            return Response.ok(page);
        } catch (Exception e) {
            logger.info("获取数据出现错误", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @ApiOperation(value = "按用户统计", notes = "按用户统计", response = Object.class)
    @GetMapping("/org/group")
    public Object getExamGroupByOrg(
            @RequestParam(name = "startAt", required = false) String startAt,
            @RequestParam(name = "endAt", required = false) String endAt,
            @RequestParam(name = "orgNameLike", required = false) String orgCodeOrNameLike) {
        //TODO
        return null;
    }

    /**
     * 从考试服务迁到报表服务
     *
     * @param startTime
     * @param endTime
     * @param orgNameLike
     * @param accountNameLike
     * @return
     */
    @ApiOperation(value = "按用户统计结果下载", notes = "按用户统计结果下载", response = ReportExamAccountVO.class)
    @GetMapping("/account/group/download")
    public Response<String> getAccountGroupDownload(
            @ApiParam(value = "开始时间", required = false) @RequestParam(name = "startTime", required = false) String startTime,
            @ApiParam(value = "结束时间", required = false) @RequestParam(name = "endTime", required = false) String endTime,
            @ApiParam(value = "部门编码或部门名称", required = false) @RequestParam(name = "orgNameLike", required = false) String orgNameLike,
            @ApiParam(value = "用户关键字", required = false) @RequestParam(name = "accountNameLike", required = false) String accountNameLike) {

        ExamCountByUserVO vo = new ExamCountByUserVO();
        vo.setStartTime(startTime);
        vo.setEndTime(endTime);
        if (StringUtils.isNotBlank(orgNameLike)) {
            vo.setOrgNameLike(orgNameLike.trim());
        }
        if (StringUtils.isNotBlank(accountNameLike)) {
            vo.setAccountNameLike(accountNameLike.trim());
        }
        try {
            String serialNo = statisticsExamClient.getAccountGroupDownload(vo);
            return Response.ok("导出成功," + " " + "编号:" + serialNo);
        } catch (Exception e) {
            e.printStackTrace();
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    /**
     * 从考试服务迁到报表服务
     *
     * @param startTime
     * @param endTime
     * @param accountId
     * @param examNameLike
     * @param pageSize
     * @param pageNo
     * @return
     */
    @ApiOperation(value = "按用户统计—查看", notes = "按用户统计-查看", response = ReportExamAccountViewVo.class)
    @GetMapping("/account/group/view")
    public Response<ReportExamAccountViewVo> getAccountGroupView(
            @ApiParam(value = "开始时间", required = false) @RequestParam(name = "startTime", required = false) String startTime,
            @ApiParam(value = "结束时间", required = false) @RequestParam(name = "endTime", required = false) String endTime,
            @ApiParam(value = "学员id", required = false) @RequestParam(name = "accountId", required = true) Long accountId,
            @ApiParam(value = "考试名称", required = false) @RequestParam(name = "examNameLike", required = false) String examNameLike,
            @ApiParam(value = "每页条数，默认20", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "20") Integer pageSize,
            @ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo) {
        try {
            return Response.ok(statisticsExamClient.getAccountGroupView(startTime, endTime, accountId, examNameLike, pageSize, pageNo));
        } catch (Exception e) {
            logger.info("获取数据过程中出现错误");
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    /**
     * 从考试服务迁到报表服务
     *
     * @param startTime
     * @param endTime
     * @param examNameLike
     * @param accountId
     * @return
     */
    @ApiOperation(value = "按用户统计-查看结果下载", notes = "按用户统计-查看结果下载", response = ReportExamAccountVO.class)
    @GetMapping("/account/group/view/download")
    public Response<String> getAccountGroupViewDownload
    (
            @ApiParam(value = "开始时间", required = false) @RequestParam(name = "startTime", required = false) String startTime,
            @ApiParam(value = "结束时间", required = false) @RequestParam(name = "endTime", required = false) String endTime,
            @ApiParam(value = "考试关键字", required = false) @RequestParam(name = "examNameLike", required = false) String examNameLike,
            @ApiParam(value = "学员id", required = true) @RequestParam(name = "accountId", required = true) Long accountId) {
        try {
            String serialNo = statisticsExamClient.getAccountGroupViewDownload(startTime, endTime, examNameLike, accountId);
            return Response.ok("导出成功," + " " + "编号:" + serialNo);
        } catch (Exception e) {
            e.printStackTrace();
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @GetMapping("/asynchronous/load")
    public Response<String> AsynchronousExam(
            @ApiParam(value = "开始时间", required = false) @RequestParam(name = "startTime", required = false) String startTime,
            @ApiParam(value = "结束时间", required = false) @RequestParam(name = "endTime", required = false) String endTime) {
        statisticsExamMetadataClient.AsynchronousExam(startTime, endTime);
        return Response.ok();
    }
}
